(ns jarvis.rally.helpers
  (:require [jarvis.rally.api :as api]
            [cheshire.core :as json]
            [clojure.string :as s]))

(declare get-first-item get-artifact-ref get-decoded-body get-artifact-type get-type)


(def rally-base-url "https://rally1.rallydev.com")
(def wsapi-url (str rally-base-url "/slm/webservice/v2.0"))
(def artifact-types {"HierarchicalRequirement" "userstory"})


(defn detail-url [artifact-type artifact-oid]
  (str rally-base-url "/#/detail/" artifact-type "/" artifact-oid))

(defn formatted-id-query [formatted-id]
  (str wsapi-url "/artifact?query=( FormattedID = \"" formatted-id "\")"))

(defn message->formatted-id [message]
  (-> message
    (get "content")
    (s/split #"\s")
    (nth 1)))

(defn get-artifact
  "Returns the artifact if it exists, otherwise returns nil"
  [message]
  (when-let [ref (get-artifact-ref message)]
    (let [body (get-decoded-body ref)]
      [(get-artifact-type (get-type body)) (get-first-item body)])))

(defn- get-artifact-ref [message]
  (-> message
    (message->formatted-id)
    (formatted-id-query)
    (get-decoded-body)
    (get-in ["QueryResult" "Results" 0 "_ref"])))

(defn- get-decoded-body [url]
  (-> url
    (api/http-get)
    (get :body )
    (json/decode)))

(defn- get-first-item [map]
  (get map (first (keys map))))

(defn- get-type [map]
  (first (keys map)))

(defn- get-artifact-type [type]
  (if-let [translated-type (get artifact-types type)]
    translated-type
    (.toLowerCase type)))