(ns jarvis.plugins.meme
  (:require [jarvis.meme.helpers :as helpers]
            [clj-http.client :as client]
            [clojure.string :as s]))

(declare generate-list-message)

(defn ^{:description "meme <type of meme> <text> - Returns a generated meme with the appropriate text."
        :command "meme"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme [message]
  (let [[meme-name top bottom] (helpers/message->meme-vec message 6)
        created-meme (helpers/create-meme meme-name top bottom)]
    (if (= true (get created-meme "success"))
      (get-in created-meme ["result" "instanceImageUrl"])
      "Sorry sir, I could not create that meme for you!")))

(defn ^{:description "meme-list <page index> - Returns a list of the top 20 meme names. Page index is 0 based."
        :command "meme-list"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme-list [message]
  (let [page-index (helpers/get-page-index message)
        memes (helpers/list-memes page-index)]
    (generate-list-message (get memes "result"))))


(defn ^{:description "meme-search <meme-query> - Returns a list of items that closely match the query."
        :command "meme-search"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme-search [message]
  (let [[query] (helpers/message->meme-vec message 12)
        memes (helpers/search-memes query)]
    (generate-list-message (get memes "result"))))


(defn generate-list-message [memes]
  (->> memes
    (map #(str
            "\n\tMeme Name: " (get % "urlName")
            "\n\tMeme Pic: " (get % "imageUrl")
            "\n\t"))
    (s/join " ")))
