(ns jarvis.plugins.meme
  (:require [jarvis.meme.helpers :as helpers]
            [clj-http.client :as client]
            [clojure.string :as s]
            [clojure.edn :as edn]))

(declare message->meme-vec build-string generate-list-message get-page-index)

(defn ^{:description "meme <type of meme> <text> - Returns a generated meme with the appropriate text."
        :command "meme"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme [message]
  (let [[meme-name top bottom] (message->meme-vec message)
        created-meme (helpers/create-meme meme-name top bottom)]
    (if (= true (get created-meme "success"))
      (get-in created-meme ["result" "instanceImageUrl"])
      "Sorry sir, I could not create that meme for you!")))

(defn ^{:description "meme-list <page index> - Returns a list of the top 20 meme names. Page index is 0 based."
        :command "meme-list"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme-list [message]
  (let [page-index (get-page-index message)
        memes (helpers/list-memes page-index)]
    (generate-list-message (get memes "result"))))

(defn- get-page-index [message]
  (re-find #"\d" (get message "content")))

(defn message->meme-vec [message]
  (-> message
    (get "content")
    (.substring 6)
    build-string
    (edn/read-string)))

(defn build-string [content]
  (str "[" content "]"))

(defn generate-list-message [memes]
  (->> memes
    (map #(str
            "\n\tMeme Name: " (get % "urlName")
            "\n\tMeme Pic: " (get % "imageUrl")
            "\n\t"))
    (s/join " ")))
