(ns jarvis.meme.util)

(defn- env-variable [name]
  (-> (System/getenv)
    (get name)))

(defn config-property
  ([name]
    (config-property name nil))
  ([name default-value]
    (if-let [env-value (env-variable name)]
      env-value
      (if-let [system-value (System/getProperty name)]
        system-value
        default-value))))