(ns jarvis.meme.helpers
  (:require [jarvis.meme.util :as util]
            [clj-http.client :as client]
            [cheshire.core :as json]
            [clojure.string :as s]))

(declare query-meme parse-image-id get-memes)

(def create-url "http://version1.api.memegenerator.net/Instance_Create?")
(def username (util/config-property "MEME_USERNAME"))
(def password (util/config-property "MEME_PASSWORD"))
(def memes (atom []))

(defn meme-query-url [meme-name] (str "http://version1.api.memegenerator.net/Generator_Select_ByUrlNameOrGeneratorID?urlName=" meme-name))
(defn list-url [page-size page-index] (str "http://version1.api.memegenerator.net/Generators_Select_ByPopular?pageIndex=" page-index "&pageSize=" page-size "&days=7"))

(defn create-meme [meme-name top-text bottom-text]
  (let [meme (query-meme (name meme-name))
        generator-id (get-in meme ["result" "generatorID"])
        image-id (parse-image-id (get-in meme ["result" "imageUrl"]))
        url (str create-url "username=" username "&password=" password "&languageCode=en&generatorID=" generator-id "&imageID=" image-id "&text0=" top-text "&text1=" bottom-text)]
    (-> url
      (client/get)
      (get :body )
      (json/decode))))

(defn query-meme [meme-name]
  (-> meme-name
    meme-query-url
    (client/get {:basic-auth [username password]})
    (get :body )
    (json/decode)))

(defn list-memes []
  (get-memes 20 0))

(defn list-all-memes []
  (for [x (range 5)]
    (let [results (cons @memes (get (get-memes 20 x) "result"))]
      results)))

(defn- get-memes [page-size page-index]
  (-> (list-url page-size page-index)
    (client/get)
    (get :body )
    (json/decode)))

(defn parse-image-id [image-url]
  (first (s/split (re-find #"\d+.jpg" image-url) #"\.")))
