(ns jarvis.plugins.meme
  (:require [jarvis.meme.helpers :as helpers]
            [clj-http.client :as client]
            [clojure.string :as s]
            [clojure.edn :as edn]))

(declare message->meme-vec build-string generate-list-message)

(defn ^{:description "meme <type of meme> <text> - Returns a generated meme with the appropriate text."
        :command "meme"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme [message]
  (let [[meme-name top bottom] (message->meme-vec message)
        created-meme (helpers/create-meme meme-name top bottom)]
    (if (= true (get created-meme "success"))
      (get-in created-meme ["result" "instanceImageUrl"])
      "Sorry sir, I could not create that meme for you!")))

(defn ^{:description "meme-list - Returns a list of the top 20 meme names."
        :command "meme-list"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme-list [message]
  (let [memes (helpers/list-memes)]
    (generate-list-message (get memes "result"))))

(defn ^{:description "meme-list - Returns a list of the top 100 meme names."
        :command "meme-list-all"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  meme-list-all [message]
  (let [memes (flatten (helpers/list-all-memes))]
    (generate-list-message memes)))

(defn message->meme-vec [message]
  (-> message
    (get "content")
    (.substring 6)
    build-string
    (edn/read-string)))

(defn build-string [content]
  (str "[" content "]"))

(defn generate-list-message [memes]
  (->> memes
    (map #(str
            "\n\tMeme Name: " (get % "urlName")
            "\n\tMeme Pic: " (get % "imageUrl")
            "\n\t"))
    (s/join " ")))
