(ns jarvis.meme.helpers
  (:require [jarvis.meme.util :as util]
            [clj-http.client :as client]
            [cheshire.core :as json]
            [clojure.string :as s]))

(declare query-meme parse-image-id)

(def create-url "http://version1.api.memegenerator.net/Instance_Create?")
(def username (util/config-property "MEME_USERNAME"))
(def password (util/config-property "MEME_PASSWORD"))

(defn meme-query-url [meme-name] (str "http://version1.api.memegenerator.net/Generator_Select_ByUrlNameOrGeneratorID?urlName=" meme-name))

(defn create-meme [meme-name top-text bottom-text]
  (let [meme (query-meme (name meme-name))
        generator-id (get-in meme ["result" "generatorID"])
        image-id (parse-image-id (get-in meme ["result" "imageUrl"]))
        url (str create-url "username=" username "&password=" password "&languageCode=en&generatorID=" generator-id "&imageID=" image-id "&text0=" top-text "&text1=" bottom-text)]
    (-> url
      (client/get)
      (get :body)
      (json/decode))))

(defn query-meme [meme-name]
  (-> meme-name
    meme-query-url
    (client/get {:basic-auth [username password]})
    (get :body )
    (json/decode)))

(defn list-memes []
  (-> "http://version1.api.memegenerator.net/Generators_Select_ByPopular?pageIndex=0&pageSize=20&days=7"
    (client/get)
    (get :body)
    (json/decode)))

(defn parse-image-id [image-url]
  (first (s/split (re-find #"\d+.jpg" image-url) #"\.")))