(ns clj-rally.api.typedefinition
  (:require [clj-rally.api.workspace :as workspace]
            [clj-rally.api :as api]
            [clj-rally.util :as util]
            [clojure.core.cache :as cache]))

(declare get-type-defs formatted-id-prefix->ref-object-name-map)

(def TTL (util/config-property "TYPEDEF_CACHE_TTL" 43200000)) ;defaults to 12 hours
(def prefix-cache (atom (cache/ttl-cache-factory {} :ttl TTL)))

(defn get-type-defs
  ([]
    (get-type-defs (get (.artifact (workspace/get-current)) "ObjectID")))
  ([oid]
    (let [url (str api/schema-url "/workspace/" oid)]
      (api/http-get url))))

(defn prefix->ref-name
  ([]
    (if (empty? (keys @prefix-cache))
      (prefix->ref-name (.results (get-type-defs)))
      @prefix-cache))
  ([typedefs]
    (if (empty? (keys @prefix-cache))
      (let [prefix-map (into {} (for [typedef typedefs] [(get typedef "IDPrefix") (get typedef "_refObjectName")]))]
        (reset! prefix-cache prefix-map)))
    @prefix-cache))

(defn empty-prefix-cache []
  (reset! prefix-cache {}))
