(ns clj-rally.api.artifact
  (:require [clj-rally.api.typedefinition :as typedefinition]
            [clj-rally.api :as api])
  (:refer-clojure :exclude [get]))

(declare formatted-id-prefix formatted-id->type)

(defn get
  "Returns a WsapiResponse object"
  [type oid]
  (let [url (str api/wsapi-url "/" type "/" oid)]
    (api/http-get url)))

(defn get-by-formatted-id [formatted-id]
  (let [type (formatted-id->type formatted-id)
        url (str api/wsapi-url "/" type "?query=( FormattedID = " formatted-id " )")
        result (api/http-get url)]
    (api/http-get (clojure.core/get (first (.results result)) "_ref"))))

(defn formatted-id-prefix [formatted-id]
  (re-find #"\D+" formatted-id))

(defn formatted-id->type [formatted-id]
  (let [typedef-map (typedefinition/prefix->ref-name)]
    (clojure.core/get typedef-map (formatted-id-prefix formatted-id))))