(ns clj-rally.api.workspace
  (:require [clj-rally.api :as api])
  (:refer-clojure :exclude [get]))

(defn get [oid]
  (let [url (str api/wsapi-url "/workspace/" oid)]
    (api/http-get url)))

(defn get-current []
  (let [url (str api/wsapi-url "/workspace")]
    (-> url
      (api/http-get)
      (.results)
      first
      (clojure.core/get "_ref")
      (api/http-get))))