(ns clj-rally.api.typedefinition
  (:require [clj-rally.api.workspace :as workspace]
            [clj-rally.api :as api]))

(defn get-type-defs
  ([]
    (get-type-defs (get (.artifact (workspace/get-current)) "ObjectID")))
  ([oid]
    (let [url (str api/schema-url "/workspace/" oid)]
      (api/http-get url))))

(defn get-current-workspace-type-defs []
  (let [current-workspace (workspace/get-current)
        current-workspace-oid (get (.artifact current-workspace) "ObjectID")
        url (str api/schema-url "/workspace/" current-workspace-oid)]
    (api/http-get url)))

(defn formatted-id-prefix->ref-object-name-map
  ([]
    (formatted-id-prefix->ref-object-name-map (.results (get-current-workspace-type-defs))))
  ([typedefs]
    (into {} (for [typedef typedefs] [(get typedef "IDPrefix") (get typedef "_refObjectName")]))))