(ns clj-rally.api
  (:require [clj-rally.util :as util]
            [clj-http.client :as client]
            [cheshire.core :as json]))

(defprotocol Response
  (page-size [this] "Number of items returned per page")
  (start [this] "Starting position")
  (total [this] "Total number of items returned")
  (errors [this] "Vector of errors returned from issuing the query")
  (warnings [this] "Vector of warnings returned from issuing the query")
  (results [this] "Vector of results from issuing the query")
  (artifact [this] "Returns the artifact that was returned from issuing the get request")
  (artifact-type [this] "Returns the artifact type for the get request"))

(deftype WsapiResponse [response]
  Response
  (artifact [this]
    (get response (first (keys response))))
  (artifact-type [this]
    (first (keys response)))
  (page-size [this]
    (get-in response ["QueryResult" "PageSize"]))
  (start [this]
    (get-in response ["QueryResult" "StartIndex"]))
  (total [this]
    (get-in response ["QueryResult" "TotalResultCount"]))
  (errors [this]
    (get-in response ["QueryResult" "Errors"]))
  (warnings [this]
    (get-in response ["QueryResult" "Warnings"]))
  (results [this]
    (get-in response ["QueryResult" "Results"])))

(def base-url "https://rally1.rallydev.com/slm")
(def wsapi-url (str base-url "/webservice/v2.x"))
(def schema-url (str base-url "/schema/v2.x"))
(def username (util/config-property "RALLY_USERNAME"))
(def password (util/config-property "RALLY_PASSWORD"))

(defn http-get [url]
  (-> url
    (client/get {:basic-auth [username password]
                 :throw-exceptions false})
    (get :body)
    (json/decode)
    (WsapiResponse. )))