(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with roles on the chef api - http://docs.opscode.com/api_chef_server_roles.html"}
  clj-chef.api.role
  (:require [clj-chef.api :as api]
            [cheshire.core :as json]))

(def route "/roles")

(defn list-roles
  "GET /org/org-name/roles will return a map of all roles where the key is the role name and the value is the corresponding api url."
  []
  (api/http-get route))

(defn get-role
  "GET /org/org-name/roles/<name> will return a map of the role, with entries like run_list, default_attributes, and override_attributes."
  [name]
  (api/http-get (str route "/" name)))

(defn role->environments
  "GET /org/org-name/roles/<name>/environments will return a vector of the environments assigned to the given role."
  [name]
  (api/http-get (str route "/" name "/environments")))

(defn role->environment-run-list
  "GET /org/org-name/roles/<name>/environments/<env-name> will return a vector of the run-list for the given role and environment."
  [role-name env-name]
  (api/http-get (str route "/" role-name "/environments/" env-name)))