(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with nodes on the chef api - http://docs.opscode.com/api_chef_server_nodes.html"}
  clj-chef.api.node
  (:require [clj-chef.api :as api]
            [cheshire.core :as json]))

(def route "/nodes")

(defn list-nodes
  "GET /org/org-name/nodes will return a map of all nodes where the key is the node name and the value is the corresponding api url."
  []
  (api/http-get route))

(defn get-node
  "GET /org/org-name/nodes/<name> will return a map of the details of the node."
  [name]
  (api/http-get (str route "/" name)))

