(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with environments on the chef api - http://docs.opscode.com/api_chef_server_environments.html"}
  clj-chef.api.environment
  (:require [clj-chef.api :as api]
            [cheshire.core :as json]))

(def route "/environments")

(defn list-environments
  "GET /org/org-name/environments will return a map of all environments where the key is the environment name and the value is the corresponding api url."
  []
  (api/http-get route))

(defn get-environment
  "GET /org/org-name/environments/<name> will return a map of the details of the environment."
  [environment-name]
  (api/http-get (str route "/" environment-name)))

(defn get-cookbook
  "GET /org/org-name/environments/<name>/cookbooks/<name> will return the cookbook information for the specified environment.
  You can also specifiy the number of versions to return > 0 or all"
  ([environment-name cookbook-name]
    (get-cookbooks environment-name cookbook-name "1"))
  ([environment-name cookbook-name num-versions]
    (api/http-get (str route "/" environment-name "/cookbooks/" cookbook-name) {"num_versions" num-versions})))

(defn get-cookbooks
  "GET /org/org-name/environments/<name>/cookbooks will return the all cookbook information for the specified environment.
  You can also specifiy the number of versions to return > 0 or all"
  ([environment-name]
    (get-cookbooks environment-name "1"))
  ([environment-name num-versions]
    (api/http-get (str route "/" environment-name "/cookbooks") {"num_versions" num-versions})))

(defn get-nodes
  "GET /org/org-name/environments/<name>/nodes will return a map of all nodes where the key is the node name and the value is the corresponding api url."
  [environment-name]
  (api/http-get (str route "/" environment-name "/nodes")))

(defn get-recipes
  "GET /org/org-name/environments/<name>/nodes will return a vector of all recipes for the given environment"
  [environment-name]
  (api/http-get (str route "/" environment-name "/recipes")))

(defn get-runlist
  "GET /org/org-name/environments/<name>/role/<name> will return the run list for the given environment and role"
  [environment-name role-name]
  (api/http-get (str route "/" environment-name "/roles/" role-name)))