(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with data bags on the chef api - http://docs.opscode.com/api_chef_server_data_bag.html"}
  clj-chef.api.data
  (:require [clj-chef.api :as api]
            [cheshire.core :as json]))

(def route "/data")

(defn list-data
  "GET /org/org-name/data will return a map of all data bags where the key is the data bag name and the value is the corresponding api url."
  []
  (api/http-get route))

(defn get-data
  "GET /org/org-name/data/<name> will return a map of the details of the data bag."
  [name]
  (api/http-get (str route "/" name)))

(defn get-data-item
  "GET /org/org-name/data/<name>/<item> will return the specified key value for the given item of the data bag."
  [name item]
  (api/http-get (str route "/" name "/" item)))

