(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with cookbooks on the chef api - http://docs.opscode.com/api_chef_server_cookbooks.html"}
  clj-chef.api.cookbook
  (:require [clj-chef.api :as api]
            [cheshire.core :as json]))

(def route "/cookbooks")

(defn list-cookbooks
  "GET /org/org-name/cookbooks will return a map of all cookbooks where the key is the cookbook name. You can also specify how many versions to return > 0 or all."
  ([]
    (list-cookbooks "1"))
  ([num-versions]
    (api/http-get route {"num_versions" num-versions})))

(defn get-cookbook
  "GET /org/org-name/cookbooks/<name> will return a map of the details of the cookbook. You can also specify how many versions to return > 0 or all."
  ([name]
    (get-cookbook name "1"))
  ([name num-versions]
    (api/http-get (str route "/" name) {"num_versions" num-versions})))

(defn version->cookbook
  "GET /org/org-name/cookbooks/<name>/<version> will return a map of the cookbook for the specified version. You can specify _latest to get the HEAD version."
  [name version]
  (api/http-get (str route "/" name "/" version)))

