(ns
  #^{:author "Jonathan Chauncey jchauncey@rallydev.com"
     :doc "A clojure library for interacting with clients on the chef api - http://docs.opscode.com/api_chef_server_clients.html"}
  clj-chef.api.client
  (:require [clj-chef.api :as api]
            [clj-chef.util :as util]
            [cheshire.core :as json]))

(def route "/clients")

(defn list-clients
  "GET /org/org-name/clients will return a map of all clients where the key is the client name and the value is the corresponding api url."
  []
  (api/http-get route))

(defn get-client
  "GET /org/org-name/clients/<name> will return a map of the details of the client."
  [name]
  (api/http-get (str route "/" name)))

