(ns schema.extensions.field
  (:require [schema.core :as s]
            [schema.spec.core :as spec]
            [schema.spec.variant :as variant]
            [schema.extensions.endpoint :refer [endpoint]]
            [schema.extensions.derived :refer [derived defaulting massaging]]
            #?(:cljs [schema.core :refer [Schema]]))
  #?(:clj (:import [schema.core Schema])))

(def field-meta schema.extensions.util/field-meta)

;; Some things reproduced from ring.swagger.schema

(defrecord FieldSchema [schema]
  Schema
  (spec [this]
    (variant/variant-spec
     spec/+no-precondition+
     [{:schema schema}]))
  (explain [this] (s/explain schema)))

(defn field
  "Attaches meta-data to a schema under :json-schema key. If the
   schema is of type which cannot have meta-data (e.g. Java Classes)
   schema is wrapped first into s/conditional Schema."
  [schema & extra]
  (let [extra (if (map? (first extra)) (first extra) (apply hash-map extra))
        field- (if #?(:clj (instance? clojure.lang.IObj schema)
                      :cljs (and (not= (type schema) js/Function)
                                 (satisfies? IMeta schema)))
                 schema
                 (->FieldSchema schema))
        extra (cond-> extra
                (contains? extra :derived)
                (merge (derived (:derived extra)))

                (contains? extra :default)
                (merge (defaulting (:default extra)))

                (contains? extra :optional)
                (merge (defaulting nil))

                (contains? extra :massage)
                (merge (massaging (:massage extra)))

                (contains? extra :autodef)
                (merge (defaulting (empty schema)))

                (contains? extra :endpoint)
                (merge (endpoint (:endpoint extra))))]
    (with-meta field-
      (merge (meta schema) {:json-schema extra}))))

(defn describe
  "Attach description and possibly other meta-data to a schema."
  [schema desc & {:as kvs}]
  (field schema (merge {:description desc} kvs)))

