/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDoubleMatrix;
import org.jblas.ComplexFloatMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.NativeBlas;
import org.jblas.util.Functions;

public class Singular {
    public static DoubleMatrix[] fullSVD(DoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        DoubleMatrix U = new DoubleMatrix(m, m);
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        DoubleMatrix V = new DoubleMatrix(n, n);
        NativeBlas.dgesvd('A', 'A', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, n);
        return new DoubleMatrix[]{U, S, V.transpose()};
    }

    public static DoubleMatrix[] sparseSVD(DoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        DoubleMatrix U = new DoubleMatrix(m, Functions.min(m, n));
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        DoubleMatrix V = new DoubleMatrix(Functions.min(m, n), n);
        NativeBlas.dgesvd('S', 'S', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, Functions.min(m, n));
        return new DoubleMatrix[]{U, S, V.transpose()};
    }

    public static ComplexDoubleMatrix[] sparseSVD(ComplexDoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        ComplexDoubleMatrix U = new ComplexDoubleMatrix(m, Functions.min(m, n));
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        ComplexDoubleMatrix V = new ComplexDoubleMatrix(Functions.min(m, n), n);
        double[] rwork = new double[5 * Functions.min(m, n)];
        NativeBlas.zgesvd('S', 'S', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, Functions.min(m, n), rwork, 0);
        return new ComplexDoubleMatrix[]{U, new ComplexDoubleMatrix(S), V.hermitian()};
    }

    public static ComplexDoubleMatrix[] fullSVD(ComplexDoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        ComplexDoubleMatrix U = new ComplexDoubleMatrix(m, m);
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        ComplexDoubleMatrix V = new ComplexDoubleMatrix(n, n);
        double[] rwork = new double[5 * Functions.min(m, n)];
        NativeBlas.zgesvd('A', 'A', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, n, rwork, 0);
        return new ComplexDoubleMatrix[]{U, new ComplexDoubleMatrix(S), V.hermitian()};
    }

    public static DoubleMatrix SVDValues(DoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        NativeBlas.dgesvd('N', 'N', m, n, A.dup().data, 0, m, S.data, 0, null, 0, 1, null, 0, 1);
        return S;
    }

    public static DoubleMatrix SVDValues(ComplexDoubleMatrix A) {
        int m = A.rows;
        int n = A.columns;
        DoubleMatrix S = new DoubleMatrix(Functions.min(m, n));
        double[] rwork = new double[5 * Functions.min(m, n)];
        NativeBlas.zgesvd('N', 'N', m, n, A.dup().data, 0, m, S.data, 0, null, 0, 1, null, 0, Functions.min(m, n), rwork, 0);
        return S;
    }

    public static FloatMatrix[] fullSVD(FloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        FloatMatrix U = new FloatMatrix(m, m);
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        FloatMatrix V = new FloatMatrix(n, n);
        NativeBlas.sgesvd('A', 'A', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, n);
        return new FloatMatrix[]{U, S, V.transpose()};
    }

    public static FloatMatrix[] sparseSVD(FloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        FloatMatrix U = new FloatMatrix(m, Functions.min(m, n));
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        FloatMatrix V = new FloatMatrix(Functions.min(m, n), n);
        NativeBlas.sgesvd('S', 'S', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, Functions.min(m, n));
        return new FloatMatrix[]{U, S, V.transpose()};
    }

    public static ComplexFloatMatrix[] sparseSVD(ComplexFloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        ComplexFloatMatrix U = new ComplexFloatMatrix(m, Functions.min(m, n));
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        ComplexFloatMatrix V = new ComplexFloatMatrix(Functions.min(m, n), n);
        float[] rwork = new float[5 * Functions.min(m, n)];
        NativeBlas.cgesvd('S', 'S', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, Functions.min(m, n), rwork, 0);
        return new ComplexFloatMatrix[]{U, new ComplexFloatMatrix(S), V.hermitian()};
    }

    public static ComplexFloatMatrix[] fullSVD(ComplexFloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        ComplexFloatMatrix U = new ComplexFloatMatrix(m, m);
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        ComplexFloatMatrix V = new ComplexFloatMatrix(n, n);
        float[] rwork = new float[5 * Functions.min(m, n)];
        NativeBlas.cgesvd('A', 'A', m, n, A.dup().data, 0, m, S.data, 0, U.data, 0, m, V.data, 0, n, rwork, 0);
        return new ComplexFloatMatrix[]{U, new ComplexFloatMatrix(S), V.hermitian()};
    }

    public static FloatMatrix SVDValues(FloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        NativeBlas.sgesvd('N', 'N', m, n, A.dup().data, 0, m, S.data, 0, null, 0, 1, null, 0, 1);
        return S;
    }

    public static FloatMatrix SVDValues(ComplexFloatMatrix A) {
        int m = A.rows;
        int n = A.columns;
        FloatMatrix S = new FloatMatrix(Functions.min(m, n));
        float[] rwork = new float[5 * Functions.min(m, n)];
        NativeBlas.cgesvd('N', 'N', m, n, A.dup().data, 0, m, S.data, 0, null, 0, 1, null, 0, Functions.min(m, n), rwork, 0);
        return S;
    }
}

