/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDouble;
import org.jblas.ComplexDoubleMatrix;
import org.jblas.ComplexFloat;
import org.jblas.ComplexFloatMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.JavaBlas;
import org.jblas.NativeBlas;
import org.jblas.exceptions.LapackArgumentException;
import org.jblas.exceptions.LapackConvergenceException;
import org.jblas.exceptions.LapackException;
import org.jblas.exceptions.LapackSingularityException;

public class SimpleBlas {
    public static DoubleMatrix swap(DoubleMatrix x, DoubleMatrix y) {
        JavaBlas.rswap(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static DoubleMatrix scal(double alpha, DoubleMatrix x) {
        NativeBlas.dscal(x.length, alpha, x.data, 0, 1);
        return x;
    }

    public static ComplexDoubleMatrix scal(ComplexDouble alpha, ComplexDoubleMatrix x) {
        NativeBlas.zscal(x.length, alpha, x.data, 0, 1);
        return x;
    }

    public static DoubleMatrix copy(DoubleMatrix x, DoubleMatrix y) {
        JavaBlas.rcopy(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static ComplexDoubleMatrix copy(ComplexDoubleMatrix x, ComplexDoubleMatrix y) {
        NativeBlas.zcopy(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static DoubleMatrix axpy(double da, DoubleMatrix dx, DoubleMatrix dy) {
        JavaBlas.raxpy(dx.length, da, dx.data, 0, 1, dy.data, 0, 1);
        return dy;
    }

    public static ComplexDoubleMatrix axpy(ComplexDouble da, ComplexDoubleMatrix dx, ComplexDoubleMatrix dy) {
        NativeBlas.zaxpy(dx.length, da, dx.data, 0, 1, dy.data, 0, 1);
        return dy;
    }

    public static double dot(DoubleMatrix x, DoubleMatrix y) {
        return JavaBlas.rdot(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static ComplexDouble dotc(ComplexDoubleMatrix x, ComplexDoubleMatrix y) {
        return NativeBlas.zdotc(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static ComplexDouble dotu(ComplexDoubleMatrix x, ComplexDoubleMatrix y) {
        return NativeBlas.zdotu(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static double nrm2(DoubleMatrix x) {
        return NativeBlas.dnrm2(x.length, x.data, 0, 1);
    }

    public static double nrm2(ComplexDoubleMatrix x) {
        return NativeBlas.dznrm2(x.length, x.data, 0, 1);
    }

    public static double asum(DoubleMatrix x) {
        return NativeBlas.dasum(x.length, x.data, 0, 1);
    }

    public static double asum(ComplexDoubleMatrix x) {
        return NativeBlas.dzasum(x.length, x.data, 0, 1);
    }

    public static int iamax(DoubleMatrix x) {
        return NativeBlas.idamax(x.length, x.data, 0, 1) - 1;
    }

    public static int iamax(ComplexDoubleMatrix x) {
        return NativeBlas.izamax(x.length, x.data, 0, 1);
    }

    public static DoubleMatrix gemv(double alpha, DoubleMatrix a, DoubleMatrix x, double beta, DoubleMatrix y) {
        if (beta == 0.0) {
            for (int i = 0; i < y.length; ++i) {
                y.data[i] = 0.0;
            }
            for (int j = 0; j < a.columns; ++j) {
                double xj = x.get(j);
                if (xj == 0.0) continue;
                for (int i = 0; i < a.rows; ++i) {
                    int n = i;
                    y.data[n] = y.data[n] + a.get(i, j) * xj;
                }
            }
        } else {
            for (int j = 0; j < a.columns; ++j) {
                double byj = beta * y.data[j];
                double xj = x.get(j);
                for (int i = 0; i < a.rows; ++i) {
                    y.data[j] = a.get(i, j) * xj + byj;
                }
            }
        }
        return y;
    }

    public static DoubleMatrix ger(double alpha, DoubleMatrix x, DoubleMatrix y, DoubleMatrix a) {
        NativeBlas.dger(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static ComplexDoubleMatrix geru(ComplexDouble alpha, ComplexDoubleMatrix x, ComplexDoubleMatrix y, ComplexDoubleMatrix a) {
        NativeBlas.zgeru(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static ComplexDoubleMatrix gerc(ComplexDouble alpha, ComplexDoubleMatrix x, ComplexDoubleMatrix y, ComplexDoubleMatrix a) {
        NativeBlas.zgerc(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static DoubleMatrix gemm(double alpha, DoubleMatrix a, DoubleMatrix b, double beta, DoubleMatrix c) {
        NativeBlas.dgemm('N', 'N', c.rows, c.columns, a.columns, alpha, a.data, 0, a.rows, b.data, 0, b.rows, beta, c.data, 0, c.rows);
        return c;
    }

    public static ComplexDoubleMatrix gemm(ComplexDouble alpha, ComplexDoubleMatrix a, ComplexDoubleMatrix b, ComplexDouble beta, ComplexDoubleMatrix c) {
        NativeBlas.zgemm('N', 'N', c.rows, c.columns, a.columns, alpha, a.data, 0, a.rows, b.data, 0, b.rows, beta, c.data, 0, c.rows);
        return c;
    }

    public static DoubleMatrix gesv(DoubleMatrix a, int[] ipiv, DoubleMatrix b) {
        int info = NativeBlas.dgesv(a.rows, b.columns, a.data, 0, a.rows, ipiv, 0, b.data, 0, b.rows);
        SimpleBlas.checkInfo("DGESV", info);
        if (info > 0) {
            throw new LapackException("DGESV", "Linear equation cannot be solved because the matrix was singular.");
        }
        return b;
    }

    private static void checkInfo(String name, int info) {
        if (info < -1) {
            throw new LapackArgumentException(name, info);
        }
    }

    public static DoubleMatrix sysv(char uplo, DoubleMatrix a, int[] ipiv, DoubleMatrix b) {
        int info = NativeBlas.dsysv(uplo, a.rows, b.columns, a.data, 0, a.rows, ipiv, 0, b.data, 0, b.rows);
        SimpleBlas.checkInfo("SYSV", info);
        if (info > 0) {
            throw new LapackSingularityException("SYV", "Linear equation cannot be solved because the matrix was singular.");
        }
        return b;
    }

    public static int syev(char jobz, char uplo, DoubleMatrix a, DoubleMatrix w) {
        int info = NativeBlas.dsyev(jobz, uplo, a.rows, a.data, 0, a.rows, w.data, 0);
        if (info > 0) {
            throw new LapackConvergenceException("SYEV", "Eigenvalues could not be computed " + info + " off-diagonal elements did not converge");
        }
        return info;
    }

    public static int syevx(char jobz, char range, char uplo, DoubleMatrix a, double vl, double vu, int il, int iu, double abstol, DoubleMatrix w, DoubleMatrix z) {
        int n = a.rows;
        int[] m = new int[1];
        int[] iwork = new int[5 * n];
        int[] ifail = new int[n];
        int info = NativeBlas.dsyevx(jobz, range, uplo, n, a.data, 0, a.rows, vl, vu, il, iu, abstol, m, 0, w.data, 0, z.data, 0, z.rows, iwork, 0, ifail, 0);
        if (info > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Not all eigenvalues converged. Non-converging eigenvalues were: ");
            for (int i = 0; i < info; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(ifail[i]);
            }
            msg.append(".");
            throw new LapackConvergenceException("SYEVX", msg.toString());
        }
        return info;
    }

    public static int syevd(char jobz, char uplo, DoubleMatrix A, DoubleMatrix w) {
        int n = A.rows;
        int info = NativeBlas.dsyevd(jobz, uplo, n, A.data, 0, A.rows, w.data, 0);
        if (info > 0) {
            throw new LapackConvergenceException("SYEVD", "Not all eigenvalues converged.");
        }
        return info;
    }

    public static int syevr(char jobz, char range, char uplo, DoubleMatrix a, double vl, double vu, int il, int iu, double abstol, DoubleMatrix w, DoubleMatrix z, int[] isuppz) {
        int n = a.rows;
        int[] m = new int[1];
        int info = NativeBlas.dsyevr(jobz, range, uplo, n, a.data, 0, a.rows, vl, vu, il, iu, abstol, m, 0, w.data, 0, z.data, 0, z.rows, isuppz, 0);
        SimpleBlas.checkInfo("SYEVR", info);
        return info;
    }

    public static void posv(char uplo, DoubleMatrix A, DoubleMatrix B) {
        int n = A.rows;
        int nrhs = B.columns;
        int info = NativeBlas.dposv(uplo, n, nrhs, A.data, 0, A.rows, B.data, 0, B.rows);
        SimpleBlas.checkInfo("DPOSV", info);
        if (info > 0) {
            throw new LapackArgumentException("DPOSV", "Leading minor of order i of A is not positive definite.");
        }
    }

    public static int geev(char jobvl, char jobvr, DoubleMatrix A, DoubleMatrix WR, DoubleMatrix WI, DoubleMatrix VL, DoubleMatrix VR) {
        int info = NativeBlas.dgeev(jobvl, jobvr, A.rows, A.data, 0, A.rows, WR.data, 0, WI.data, 0, VL.data, 0, VL.rows, VR.data, 0, VR.rows);
        if (info > 0) {
            throw new LapackConvergenceException("DGEEV", "First " + info + " eigenvalues have not converged.");
        }
        return info;
    }

    public static int sygvd(int itype, char jobz, char uplo, DoubleMatrix A, DoubleMatrix B, DoubleMatrix W) {
        int info = NativeBlas.dsygvd(itype, jobz, uplo, A.rows, A.data, 0, A.rows, B.data, 0, B.rows, W.data, 0);
        if (info == 0) {
            return 0;
        }
        if (info < 0) {
            throw new LapackArgumentException("DSYGVD", -info);
        }
        if (info <= A.rows && jobz == 'N') {
            throw new LapackConvergenceException("DSYGVD", info + " off-diagonal elements did not converge to 0.");
        }
        if (info <= A.rows && jobz == 'V') {
            throw new LapackException("DSYGVD", "Failed to compute an eigenvalue while working on a sub-matrix  " + info + ".");
        }
        throw new LapackException("DSYGVD", "The leading minor of order " + (info - A.rows) + " of B is not positive definite.");
    }

    public static FloatMatrix swap(FloatMatrix x, FloatMatrix y) {
        JavaBlas.rswap(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static FloatMatrix scal(float alpha, FloatMatrix x) {
        NativeBlas.sscal(x.length, alpha, x.data, 0, 1);
        return x;
    }

    public static ComplexFloatMatrix scal(ComplexFloat alpha, ComplexFloatMatrix x) {
        NativeBlas.cscal(x.length, alpha, x.data, 0, 1);
        return x;
    }

    public static FloatMatrix copy(FloatMatrix x, FloatMatrix y) {
        JavaBlas.rcopy(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static ComplexFloatMatrix copy(ComplexFloatMatrix x, ComplexFloatMatrix y) {
        NativeBlas.ccopy(x.length, x.data, 0, 1, y.data, 0, 1);
        return y;
    }

    public static FloatMatrix axpy(float da, FloatMatrix dx, FloatMatrix dy) {
        JavaBlas.raxpy(dx.length, da, dx.data, 0, 1, dy.data, 0, 1);
        return dy;
    }

    public static ComplexFloatMatrix axpy(ComplexFloat da, ComplexFloatMatrix dx, ComplexFloatMatrix dy) {
        NativeBlas.caxpy(dx.length, da, dx.data, 0, 1, dy.data, 0, 1);
        return dy;
    }

    public static float dot(FloatMatrix x, FloatMatrix y) {
        return JavaBlas.rdot(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static ComplexFloat dotc(ComplexFloatMatrix x, ComplexFloatMatrix y) {
        return NativeBlas.cdotc(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static ComplexFloat dotu(ComplexFloatMatrix x, ComplexFloatMatrix y) {
        return NativeBlas.cdotu(x.length, x.data, 0, 1, y.data, 0, 1);
    }

    public static float nrm2(FloatMatrix x) {
        return NativeBlas.snrm2(x.length, x.data, 0, 1);
    }

    public static float nrm2(ComplexFloatMatrix x) {
        return NativeBlas.scnrm2(x.length, x.data, 0, 1);
    }

    public static float asum(FloatMatrix x) {
        return NativeBlas.sasum(x.length, x.data, 0, 1);
    }

    public static float asum(ComplexFloatMatrix x) {
        return NativeBlas.scasum(x.length, x.data, 0, 1);
    }

    public static int iamax(FloatMatrix x) {
        return NativeBlas.isamax(x.length, x.data, 0, 1) - 1;
    }

    public static int iamax(ComplexFloatMatrix x) {
        return NativeBlas.icamax(x.length, x.data, 0, 1);
    }

    public static FloatMatrix gemv(float alpha, FloatMatrix a, FloatMatrix x, float beta, FloatMatrix y) {
        if (beta == 0.0f) {
            for (int i = 0; i < y.length; ++i) {
                y.data[i] = 0.0f;
            }
            for (int j = 0; j < a.columns; ++j) {
                float xj = x.get(j);
                if (xj == 0.0f) continue;
                for (int i = 0; i < a.rows; ++i) {
                    int n = i;
                    y.data[n] = y.data[n] + a.get(i, j) * xj;
                }
            }
        } else {
            for (int j = 0; j < a.columns; ++j) {
                float byj = beta * y.data[j];
                float xj = x.get(j);
                for (int i = 0; i < a.rows; ++i) {
                    y.data[j] = a.get(i, j) * xj + byj;
                }
            }
        }
        return y;
    }

    public static FloatMatrix ger(float alpha, FloatMatrix x, FloatMatrix y, FloatMatrix a) {
        NativeBlas.sger(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static ComplexFloatMatrix geru(ComplexFloat alpha, ComplexFloatMatrix x, ComplexFloatMatrix y, ComplexFloatMatrix a) {
        NativeBlas.cgeru(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static ComplexFloatMatrix gerc(ComplexFloat alpha, ComplexFloatMatrix x, ComplexFloatMatrix y, ComplexFloatMatrix a) {
        NativeBlas.cgerc(a.rows, a.columns, alpha, x.data, 0, 1, y.data, 0, 1, a.data, 0, a.rows);
        return a;
    }

    public static FloatMatrix gemm(float alpha, FloatMatrix a, FloatMatrix b, float beta, FloatMatrix c) {
        NativeBlas.sgemm('N', 'N', c.rows, c.columns, a.columns, alpha, a.data, 0, a.rows, b.data, 0, b.rows, beta, c.data, 0, c.rows);
        return c;
    }

    public static ComplexFloatMatrix gemm(ComplexFloat alpha, ComplexFloatMatrix a, ComplexFloatMatrix b, ComplexFloat beta, ComplexFloatMatrix c) {
        NativeBlas.cgemm('N', 'N', c.rows, c.columns, a.columns, alpha, a.data, 0, a.rows, b.data, 0, b.rows, beta, c.data, 0, c.rows);
        return c;
    }

    public static FloatMatrix gesv(FloatMatrix a, int[] ipiv, FloatMatrix b) {
        int info = NativeBlas.sgesv(a.rows, b.columns, a.data, 0, a.rows, ipiv, 0, b.data, 0, b.rows);
        SimpleBlas.checkInfo("DGESV", info);
        if (info > 0) {
            throw new LapackException("DGESV", "Linear equation cannot be solved because the matrix was singular.");
        }
        return b;
    }

    public static FloatMatrix sysv(char uplo, FloatMatrix a, int[] ipiv, FloatMatrix b) {
        int info = NativeBlas.ssysv(uplo, a.rows, b.columns, a.data, 0, a.rows, ipiv, 0, b.data, 0, b.rows);
        SimpleBlas.checkInfo("SYSV", info);
        if (info > 0) {
            throw new LapackSingularityException("SYV", "Linear equation cannot be solved because the matrix was singular.");
        }
        return b;
    }

    public static int syev(char jobz, char uplo, FloatMatrix a, FloatMatrix w) {
        int info = NativeBlas.ssyev(jobz, uplo, a.rows, a.data, 0, a.rows, w.data, 0);
        if (info > 0) {
            throw new LapackConvergenceException("SYEV", "Eigenvalues could not be computed " + info + " off-diagonal elements did not converge");
        }
        return info;
    }

    public static int syevx(char jobz, char range, char uplo, FloatMatrix a, float vl, float vu, int il, int iu, float abstol, FloatMatrix w, FloatMatrix z) {
        int n = a.rows;
        int[] m = new int[1];
        int[] iwork = new int[5 * n];
        int[] ifail = new int[n];
        int info = NativeBlas.ssyevx(jobz, range, uplo, n, a.data, 0, a.rows, vl, vu, il, iu, abstol, m, 0, w.data, 0, z.data, 0, z.rows, iwork, 0, ifail, 0);
        if (info > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Not all eigenvalues converged. Non-converging eigenvalues were: ");
            for (int i = 0; i < info; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(ifail[i]);
            }
            msg.append(".");
            throw new LapackConvergenceException("SYEVX", msg.toString());
        }
        return info;
    }

    public static int syevd(char jobz, char uplo, FloatMatrix A, FloatMatrix w) {
        int n = A.rows;
        int info = NativeBlas.ssyevd(jobz, uplo, n, A.data, 0, A.rows, w.data, 0);
        if (info > 0) {
            throw new LapackConvergenceException("SYEVD", "Not all eigenvalues converged.");
        }
        return info;
    }

    public static int syevr(char jobz, char range, char uplo, FloatMatrix a, float vl, float vu, int il, int iu, float abstol, FloatMatrix w, FloatMatrix z, int[] isuppz) {
        int n = a.rows;
        int[] m = new int[1];
        int info = NativeBlas.ssyevr(jobz, range, uplo, n, a.data, 0, a.rows, vl, vu, il, iu, abstol, m, 0, w.data, 0, z.data, 0, z.rows, isuppz, 0);
        SimpleBlas.checkInfo("SYEVR", info);
        return info;
    }

    public static void posv(char uplo, FloatMatrix A, FloatMatrix B) {
        int n = A.rows;
        int nrhs = B.columns;
        int info = NativeBlas.sposv(uplo, n, nrhs, A.data, 0, A.rows, B.data, 0, B.rows);
        SimpleBlas.checkInfo("DPOSV", info);
        if (info > 0) {
            throw new LapackArgumentException("DPOSV", "Leading minor of order i of A is not positive definite.");
        }
    }

    public static int geev(char jobvl, char jobvr, FloatMatrix A, FloatMatrix WR, FloatMatrix WI, FloatMatrix VL, FloatMatrix VR) {
        int info = NativeBlas.sgeev(jobvl, jobvr, A.rows, A.data, 0, A.rows, WR.data, 0, WI.data, 0, VL.data, 0, VL.rows, VR.data, 0, VR.rows);
        if (info > 0) {
            throw new LapackConvergenceException("DGEEV", "First " + info + " eigenvalues have not converged.");
        }
        return info;
    }

    public static int sygvd(int itype, char jobz, char uplo, FloatMatrix A, FloatMatrix B, FloatMatrix W) {
        int info = NativeBlas.ssygvd(itype, jobz, uplo, A.rows, A.data, 0, A.rows, B.data, 0, B.rows, W.data, 0);
        if (info == 0) {
            return 0;
        }
        if (info < 0) {
            throw new LapackArgumentException("DSYGVD", -info);
        }
        if (info <= A.rows && jobz == 'N') {
            throw new LapackConvergenceException("DSYGVD", info + " off-diagonal elements did not converge to 0.");
        }
        if (info <= A.rows && jobz == 'V') {
            throw new LapackException("DSYGVD", "Failed to compute an eigenvalue while working on a sub-matrix  " + info + ".");
        }
        throw new LapackException("DSYGVD", "The leading minor of order " + (info - A.rows) + " of B is not positive definite.");
    }
}

