
package com.positronic_solutions.pulley.thread_local;

public class RootedThreadLocal extends ThreadLocal
                               implements clojure.lang.IDeref,
                                          clojure.lang.IAtom {
    private final Object root_value;

    protected Object initialValue(){
        return this.root_value;
    }

    public RootedThreadLocal(Object root_value){
        this.root_value = root_value;
    }

    public Object deref(){
        return this.get();
    }

    public Object swap(clojure.lang.IFn f){
        final Object old_value = this.deref();
        final Object new_value = f.invoke(old_value);
        return this.reset(new_value);
    }

    public Object swap(clojure.lang.IFn f, Object x){
        final Object old_value = this.deref();
        final Object new_value = f.invoke(old_value, x);
        return this.reset(new_value);
    }

    public Object swap(clojure.lang.IFn f, Object x, Object y){
        final Object old_value = this.deref();
        final Object new_value = f.invoke(old_value, x, y);
        return this.reset(new_value);
    }

    public Object swap(clojure.lang.IFn f,
                       Object x,
                       Object y,
                       clojure.lang.ISeq args){
        final Object old_value = this.deref();
        final Object new_value = f.applyTo(args.cons(y).cons(x).cons(old_value));
        return this.reset(new_value);
    }

    public boolean compareAndSet(Object oldv, Object newv){
        final Object v = this.deref();
        if(clojure.lang.Util.equiv(v, oldv)){
            this.reset(newv);
            return true;
        }
        else{
            return false;
        }
    }

    public Object reset(Object newval){
        this.set(newval);
        return newval;
    }
}
