/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.impl.DefaultJerseyServer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import java.net.URI;
import org.glassfish.jersey.server.ApplicationHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class DefaultJerseyServerTest {
    DefaultJerseyServer jerseyServer;
    URI baseUri = URI.create("http://test.englishtown.com/test");
    @Mock
    Vertx vertx;
    @Mock
    HttpServer httpServer;
    @Mock
    AsyncResult<HttpServer> asyncResult;
    @Mock
    JerseyHandler jerseyHandler;
    @Mock
    Handler<AsyncResult<HttpServer>> doneHandler;
    @Mock
    JerseyServerOptions options;
    @Mock
    HttpServerOptions serverOptions;
    @Mock
    VertxContainer container;
    @Mock
    Handler<HttpServer> setupHandler;
    @Mock
    Future<Object> future;
    @Captor
    ArgumentCaptor<Handler<AsyncResult<HttpServer>>> handlerCaptor;
    @Captor
    ArgumentCaptor<Handler<HttpServerRequest>> requestHandlerCaptor;
    @Captor
    ArgumentCaptor<HttpServerOptions> optionsCaptor;
    @Captor
    ArgumentCaptor<Handler<Future<Object>>> futureHandlerCaptor;
    @Captor
    ArgumentCaptor<Handler<AsyncResult<Object>>> resultHandlerCaptor;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        Mockito.when((Object)this.vertx.createHttpServer((HttpServerOptions)Matchers.any(HttpServerOptions.class))).thenReturn((Object)this.httpServer);
        Mockito.when((Object)this.container.getVertx()).thenReturn((Object)this.vertx);
        Mockito.when((Object)this.container.getApplicationHandler()).thenReturn((Object)new ApplicationHandler());
        Mockito.when((Object)this.options.getServerOptions()).thenReturn((Object)this.serverOptions);
        Mockito.when((Object)this.jerseyHandler.getBaseUri()).thenReturn((Object)this.baseUri);
        this.jerseyServer = new DefaultJerseyServer(this.jerseyHandler, this.container, () -> this.options);
    }

    private void verifyResults(int port, String host) {
        ((Vertx)Mockito.verify((Object)this.vertx)).createHttpServer((HttpServerOptions)this.optionsCaptor.capture());
        ((HttpServer)Mockito.verify((Object)this.httpServer)).requestHandler((Handler)this.requestHandlerCaptor.capture());
        Handler handler = (Handler)this.requestHandlerCaptor.getValue();
        Assert.assertNotNull((Object)handler);
        ((HttpServer)Mockito.verify((Object)this.httpServer)).listen((Handler)Mockito.any());
        HttpServerOptions options = (HttpServerOptions)this.optionsCaptor.getValue();
        Assert.assertEquals((long)port, (long)options.getPort());
        Assert.assertEquals((Object)host, (Object)options.getHost());
    }

    @Test
    public void testInit_Default_Config() throws Exception {
        Mockito.when((Object)this.serverOptions.getHost()).thenReturn((Object)"0.0.0.0");
        Mockito.when((Object)this.serverOptions.getPort()).thenReturn((Object)80);
        this.jerseyServer.start();
        this.verifyExecuteBlocking();
        this.verifyResults(80, "0.0.0.0");
    }

    @Test
    public void testInit_With_Config() throws Exception {
        String host = "test.englishtown.com";
        int port = 8888;
        int bufferSize = 1024;
        boolean ssl = true;
        boolean compressionSupported = true;
        Mockito.when((Object)this.serverOptions.getHost()).thenReturn((Object)host);
        Mockito.when((Object)this.serverOptions.getPort()).thenReturn((Object)port);
        Mockito.when((Object)this.serverOptions.getReceiveBufferSize()).thenReturn((Object)bufferSize);
        Mockito.when((Object)this.serverOptions.isSsl()).thenReturn((Object)ssl);
        Mockito.when((Object)this.serverOptions.isCompressionSupported()).thenReturn((Object)compressionSupported);
        this.jerseyServer.start();
        this.verifyExecuteBlocking();
        this.verifyResults(port, host);
        ((Vertx)Mockito.verify((Object)this.vertx)).createHttpServer((HttpServerOptions)this.optionsCaptor.capture());
        HttpServerOptions options = (HttpServerOptions)this.optionsCaptor.getValue();
        Assert.assertEquals((Object)host, (Object)options.getHost());
        Assert.assertEquals((long)port, (long)options.getPort());
        Assert.assertEquals((long)bufferSize, (long)options.getReceiveBufferSize());
        Assert.assertEquals((Object)ssl, (Object)options.isSsl());
        Assert.assertEquals((Object)compressionSupported, (Object)options.isCompressionSupported());
    }

    @Test
    public void testInit_Listen_Result() throws Exception {
        this.jerseyServer.start(this.doneHandler);
        this.verifyExecuteBlocking();
        ((HttpServer)Mockito.verify((Object)this.httpServer)).listen((Handler)this.handlerCaptor.capture());
        Handler handler = (Handler)this.handlerCaptor.getValue();
        Mockito.when((Object)this.asyncResult.succeeded()).thenReturn((Object)true).thenReturn((Object)false);
        handler.handle(this.asyncResult);
        handler.handle(this.asyncResult);
        ((Handler)Mockito.verify(this.doneHandler, (VerificationMode)Mockito.times((int)2))).handle((Object)((AsyncResult)Matchers.eq(this.asyncResult)));
    }

    @Test
    public void testGetHandler() throws Exception {
        this.jerseyServer.start();
        JerseyHandler handler = this.jerseyServer.getHandler();
        Assert.assertEquals((Object)this.jerseyHandler, (Object)handler);
    }

    @Test
    public void testSetupHandler() throws Exception {
        this.jerseyServer.setupHandler(this.setupHandler);
        this.jerseyServer.start();
        ((Handler)Mockito.verify(this.setupHandler)).handle((Object)((HttpServer)Matchers.eq((Object)this.httpServer)));
        JerseyHandler requestHandler = this.jerseyServer.getHandler();
        Assert.assertNotNull((Object)requestHandler);
        this.httpServer.requestHandler(request -> {});
    }

    @Test
    public void testGetHttpServer() throws Exception {
        this.jerseyServer.start();
        HttpServer server = this.jerseyServer.getHttpServer();
        Assert.assertEquals((Object)this.httpServer, (Object)server);
    }

    private void verifyExecuteBlocking() {
        ((Vertx)Mockito.verify((Object)this.vertx)).executeBlocking((Handler)this.futureHandlerCaptor.capture(), (Handler)this.resultHandlerCaptor.capture());
        ((Handler)this.futureHandlerCaptor.getValue()).handle(this.future);
        ((Future)Mockito.verify(this.future)).complete();
        ((Handler)this.resultHandlerCaptor.getValue()).handle(this.future);
    }
}

