/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.guice;

import com.englishtown.vertx.guice.GuiceJerseyBinder;
import com.englishtown.vertx.jersey.inject.VertxPostResponseProcessor;
import com.englishtown.vertx.jersey.inject.VertxRequestProcessor;
import com.englishtown.vertx.jersey.inject.VertxResponseProcessor;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import java.util.List;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class GuiceJerseyBinderTest {
    GuiceJerseyBinder binder;
    @Mock
    Binder builder;
    @Mock
    AnnotatedBindingBuilder annotatedBindingBuilder;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.builder.skipSources((Class[])Matchers.anyVararg())).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.bind((Class)Matchers.any(Class.class))).thenReturn((Object)this.annotatedBindingBuilder);
        Mockito.when((Object)this.annotatedBindingBuilder.to((Class)Matchers.any(Class.class))).thenReturn((Object)((ScopedBindingBuilder)Mockito.mock(ScopedBindingBuilder.class)));
        this.binder = new GuiceJerseyBinder();
    }

    @Test
    public void testConfigure() throws Exception {
        this.binder.configure(this.builder);
        ((Binder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)9))).bind((Class)Matchers.any(Class.class));
        ((Binder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.times((int)11))).install((Module)Matchers.any(Module.class));
    }

    @Test
    public void testProviders() throws Exception {
        List list = this.binder.provideVertxRequestProcessorList((Set)Sets.newHashSet((Object[])new VertxRequestProcessor[]{(VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class), (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class)}));
        Assert.assertEquals((long)2L, (long)list.size());
        list = this.binder.provideVertxResponseProcessorList((Set)Sets.newHashSet((Object[])new VertxResponseProcessor[]{(VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class), (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class)}));
        Assert.assertEquals((long)2L, (long)list.size());
        list = this.binder.provideVertxPostResponseProcessorList((Set)Sets.newHashSet((Object[])new VertxPostResponseProcessor[]{(VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class), (VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class)}));
        Assert.assertEquals((long)2L, (long)list.size());
    }
}

