/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.integration;

import com.englishtown.vertx.jersey.JerseyServer;
import com.englishtown.vertx.jersey.integration.GuiceTestServiceLocator;
import com.englishtown.vertx.jersey.integration.HK2TestServiceLocator;
import com.englishtown.vertx.jersey.integration.TestServiceLocator;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.junit.Test;

public abstract class ContainerLifecycleListenerIntegrationTests
extends VertxTestBase {
    private final ListenerServiceLocator locator;
    private TestLifeCycleListener listener;

    protected ContainerLifecycleListenerIntegrationTests(ListenerServiceLocator locator) {
        this.locator = locator;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.locator.init(this.vertx);
        this.listener = this.locator.getListener();
    }

    @Test
    public void testListener() throws Exception {
        this.vertx.runOnContext(aVoid -> {
            this.vertx.getOrCreateContext().config().put("jersey", new JsonObject().put("port", Integer.valueOf(8080)).put("packages", new JsonArray().add("com.englishtown.vertx.jersey.resources")));
            this.assertFalse(this.listener.started);
            this.assertFalse(this.listener.shutdown);
            JerseyServer server = this.locator.getService(JerseyServer.class);
            this.assertFalse(this.listener.started);
            this.assertFalse(this.listener.shutdown);
            server.start(result -> {
                this.assertTrue(result.succeeded());
                this.assertTrue(this.listener.started);
                this.assertFalse(this.listener.shutdown);
                server.close();
                this.assertTrue(this.listener.shutdown);
                this.testComplete();
            });
        });
        this.await();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.locator.tearDown();
    }

    public static class HK2
    extends ContainerLifecycleListenerIntegrationTests {
        public HK2() {
            super(new HK2ListenerLocator());
        }

        private static class HK2ListenerLocator
        extends HK2TestServiceLocator
        implements ListenerServiceLocator {
            private HK2ListenerLocator() {
            }

            @Override
            public void init(Vertx vertx) {
                super.init(vertx);
                ServiceLocatorUtilities.bind((ServiceLocator)this.locator, (org.glassfish.hk2.utilities.Binder[])new org.glassfish.hk2.utilities.Binder[]{new AbstractBinder(){

                    protected void configure() {
                        this.bind(TestLifeCycleListener.class).to(ContainerLifecycleListener.class).in(Singleton.class);
                    }
                }});
            }

            @Override
            public TestLifeCycleListener getListener() {
                List listeners = this.locator.getAllServices(ContainerLifecycleListener.class, new Annotation[0]);
                return (TestLifeCycleListener)listeners.get(0);
            }
        }
    }

    public static class Guice
    extends ContainerLifecycleListenerIntegrationTests {
        public Guice() {
            super(new GuiceListenerLocator());
        }

        private static class GuiceListenerLocator
        extends GuiceTestServiceLocator
        implements ListenerServiceLocator {
            private GuiceListenerLocator() {
            }

            @Override
            protected List<Module> getModules(Vertx vertx) {
                ArrayList<Module> modules = new ArrayList<Module>(super.getModules(vertx));
                modules.add((Module)new AbstractModule(){

                    protected void configure() {
                        Multibinder.newSetBinder((Binder)this.binder(), ContainerLifecycleListener.class).addBinding().to(TestLifeCycleListener.class).in(Singleton.class);
                    }
                });
                return modules;
            }

            @Override
            public TestLifeCycleListener getListener() {
                Set set = (Set)this.injector.getInstance((Key)new Key<Set<ContainerLifecycleListener>>(){});
                return (TestLifeCycleListener)set.iterator().next();
            }
        }
    }

    public static interface ListenerServiceLocator
    extends TestServiceLocator {
        public TestLifeCycleListener getListener();
    }

    public static class TestLifeCycleListener
    implements ContainerLifecycleListener {
        private boolean started;
        private boolean shutdown;

        public void onStartup(Container container) {
            this.started = true;
        }

        public void onReload(Container container) {
        }

        public void onShutdown(Container container) {
            this.shutdown = true;
        }
    }
}

