/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.ApplicationHandlerDelegate;
import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.inject.ContainerResponseWriterProvider;
import com.englishtown.vertx.jersey.inject.VertxRequestProcessor;
import com.englishtown.vertx.jersey.security.DefaultSecurityContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ContainerRequest;

public class DefaultJerseyHandler
implements JerseyHandler {
    private Provider<VertxContainer> containerProvider;
    private VertxContainer container;
    private URI baseUri;
    private Integer maxBodySize;
    private final ContainerResponseWriterProvider responseWriterProvider;
    private final List<VertxRequestProcessor> requestProcessors;
    private static final Logger logger = LoggerFactory.getLogger(DefaultJerseyHandler.class);

    @Inject
    public DefaultJerseyHandler(Provider<VertxContainer> containerProvider, ContainerResponseWriterProvider responseWriterProvider, List<VertxRequestProcessor> requestProcessors) {
        this.containerProvider = containerProvider;
        this.responseWriterProvider = responseWriterProvider;
        this.requestProcessors = requestProcessors;
    }

    @Override
    public URI getBaseUri() {
        if (this.baseUri == null) {
            this.baseUri = this.getContainer().getOptions().getBaseUri();
            if (this.baseUri == null) {
                throw new IllegalStateException("baseUri is null, have you called init() first?");
            }
        }
        return this.baseUri;
    }

    public int getMaxBodySize() {
        if (this.maxBodySize == null) {
            this.maxBodySize = this.getContainer().getOptions().getMaxBodySize();
            if (this.maxBodySize <= 0) {
                this.maxBodySize = 1024000;
            }
        }
        return this.maxBodySize;
    }

    @Override
    public ApplicationHandlerDelegate getDelegate() {
        return this.getContainer().getApplicationHandlerDelegate();
    }

    @Override
    public VertxContainer getContainer() {
        if (this.container == null) {
            this.container = (VertxContainer)this.containerProvider.get();
        }
        return this.container;
    }

    @Override
    public JerseyHandler setContainer(VertxContainer container) {
        this.container = container;
        return this;
    }

    public void handle(RoutingContext routingContext) {
        HttpServerRequest vertxRequest = routingContext.request();
        if (this.shouldReadData(vertxRequest)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DefaultJerseyHandler - handle request and read body: " + vertxRequest.method() + " " + vertxRequest.uri()));
            }
            Buffer body = Buffer.buffer();
            vertxRequest.handler(buffer -> {
                body.appendBuffer(buffer.copy());
                if (body.length() > this.getMaxBodySize()) {
                    throw new RuntimeException("The input stream has exceeded the max allowed body size " + this.getMaxBodySize() + ".");
                }
            });
            vertxRequest.endHandler(aVoid -> {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes());
                this.handle(vertxRequest, inputStream);
                if (!routingContext.response().ended()) {
                    routingContext.next();
                }
            });
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DefaultJerseyHandler - handle request: " + vertxRequest.method() + " " + vertxRequest.uri()));
            }
            this.handle(vertxRequest, null);
        }
    }

    @Override
    public void handle(HttpServerRequest vertxRequest) {
        if (this.shouldReadData(vertxRequest)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DefaultJerseyHandler - handle request and read body: " + vertxRequest.method() + " " + vertxRequest.uri()));
            }
            Buffer body = Buffer.buffer();
            vertxRequest.handler(buffer -> {
                body.appendBuffer(buffer.copy());
                if (body.length() > this.getMaxBodySize()) {
                    throw new RuntimeException("The input stream has exceeded the max allowed body size " + this.getMaxBodySize() + ".");
                }
            });
            vertxRequest.endHandler(aVoid -> {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes());
                this.handle(vertxRequest, inputStream);
            });
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DefaultJerseyHandler - handle request: " + vertxRequest.method() + " " + vertxRequest.uri()));
            }
            this.handle(vertxRequest, null);
        }
    }

    protected void handle(HttpServerRequest vertxRequest, InputStream inputStream) {
        URI uri = this.getAbsoluteURI(vertxRequest);
        boolean isSecure = "https".equalsIgnoreCase(uri.getScheme());
        UriBuilder baseUriBuilder = UriBuilder.fromUri((URI)uri).replacePath(this.getBaseUri().getPath()).replaceQuery(null);
        ContainerRequest jerseyRequest = new ContainerRequest(baseUriBuilder.build(new Object[0]), uri, vertxRequest.method().name(), (SecurityContext)new DefaultSecurityContext(isSecure), (PropertiesDelegate)new MapPropertiesDelegate());
        this.handle(vertxRequest, inputStream, jerseyRequest);
    }

    protected URI getAbsoluteURI(HttpServerRequest vertxRequest) {
        String hostAndPort = vertxRequest.headers().get("Host");
        try {
            URI absoluteUri = URI.create(vertxRequest.absoluteURI());
            if (hostAndPort != null && !hostAndPort.isEmpty()) {
                int port;
                String[] parts = hostAndPort.split(":");
                String host = parts[0];
                int n = port = parts.length > 1 ? Integer.valueOf(parts[1]) : -1;
                if (!host.equalsIgnoreCase(absoluteUri.getHost()) || port != absoluteUri.getPort()) {
                    absoluteUri = UriBuilder.fromUri((URI)absoluteUri).host(host).port(port).build(new Object[0]);
                }
            }
            return absoluteUri;
        }
        catch (IllegalArgumentException e) {
            String uri = vertxRequest.uri();
            if (!uri.contains("?")) {
                throw e;
            }
            try {
                logger.warn((Object)("Invalid URI: " + uri + ".  Attempting to parse query string."), (Throwable)e);
                QueryStringDecoder decoder = new QueryStringDecoder(uri);
                StringBuilder sb = new StringBuilder(decoder.path() + "?");
                for (Map.Entry p : decoder.parameters().entrySet()) {
                    for (String value : (List)p.getValue()) {
                        sb.append((String)p.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8"));
                    }
                }
                return URI.create(sb.toString());
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    protected void handle(HttpServerRequest vertxRequest, InputStream inputStream, ContainerRequest jerseyRequest) {
        jerseyRequest.setWriter(this.responseWriterProvider.get(vertxRequest, jerseyRequest));
        if (inputStream != null) {
            jerseyRequest.setEntityStream(inputStream);
        }
        for (Map.Entry header : vertxRequest.headers().entries()) {
            jerseyRequest.getHeaders().add((Object)((String)header.getKey()), (Object)((String)header.getValue()));
        }
        jerseyRequest.setRequestScopedInitializer(locator -> {
            ((Ref)locator.getService(new TypeLiteral<Ref<HttpServerRequest>>(){}.getType(), new Annotation[0])).set((Object)vertxRequest);
            ((Ref)locator.getService(new TypeLiteral<Ref<HttpServerResponse>>(){}.getType(), new Annotation[0])).set((Object)vertxRequest.response());
        });
        if (!this.requestProcessors.isEmpty()) {
            if (inputStream == null) {
                vertxRequest.pause();
            }
            this.callVertxRequestProcessor(0, vertxRequest, jerseyRequest, (Handler<Void>)((Handler)aVoid -> {
                if (inputStream == null) {
                    vertxRequest.resume();
                }
                this.getDelegate().handle(jerseyRequest);
            }));
        } else {
            this.getDelegate().handle(jerseyRequest);
        }
    }

    protected void callVertxRequestProcessor(int index, HttpServerRequest vertxRequest, ContainerRequest jerseyRequest, Handler<Void> done) {
        if (index >= this.requestProcessors.size()) {
            done.handle(null);
        }
        VertxRequestProcessor processor = this.requestProcessors.get(index);
        int next = index + 1;
        try {
            processor.process(vertxRequest, jerseyRequest, (Handler<Void>)((Handler)aVoid -> {
                if (next >= this.requestProcessors.size()) {
                    done.handle(null);
                } else {
                    this.callVertxRequestProcessor(next, vertxRequest, jerseyRequest, done);
                }
            }));
        }
        catch (Throwable t) {
            logger.error((Object)("VertxRequestProcessor " + processor.getClass().getSimpleName() + " threw exception: " + t.getMessage()), t);
            vertxRequest.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
        }
    }

    protected boolean shouldReadData(HttpServerRequest vertxRequest) {
        HttpMethod method = vertxRequest.method();
        if (HttpMethod.POST != method && HttpMethod.PUT != method && HttpMethod.PATCH != method) {
            return false;
        }
        String contentType = vertxRequest.headers().get("Content-Type");
        if (contentType == null || contentType.isEmpty()) {
            return true;
        }
        MediaType mediaType = MediaType.valueOf((String)contentType);
        if (MediaType.TEXT_PLAIN_TYPE.getType().equals(mediaType.getType())) {
            return true;
        }
        String applicationType = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getType();
        if (!applicationType.equalsIgnoreCase(mediaType.getType())) {
            return false;
        }
        if (mediaType.getSubtype().equalsIgnoreCase(MediaType.APPLICATION_FORM_URLENCODED_TYPE.getSubtype())) {
            if (!mediaType.getParameters().isEmpty()) {
                vertxRequest.headers().remove("Content-Type");
                vertxRequest.headers().add("Content-Type", "application/x-www-form-urlencoded");
            }
            return true;
        }
        return MediaType.APPLICATION_JSON_TYPE.getSubtype().equalsIgnoreCase(mediaType.getSubtype()) || MediaType.APPLICATION_XML_TYPE.getSubtype().equalsIgnoreCase(mediaType.getSubtype());
    }
}

