/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.integration;

import com.englishtown.promises.Promise;
import com.englishtown.vertx.jersey.integration.TestServiceLocator;
import com.englishtown.vertx.promises.WhenHttpClient;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public abstract class JerseyIntegrationTestBase
extends VertxTestBase {
    private final TestServiceLocator locator;
    protected HttpClient httpClient;
    protected String deploymentID;

    protected JerseyIntegrationTestBase(TestServiceLocator locator) {
        this.locator = locator;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.init();
    }

    protected void init() throws Exception {
        this.locator.init(this.vertx);
        HttpClientOptions clientOptions = new HttpClientOptions().setConnectTimeout(1000);
        this.httpClient = this.vertx.createHttpClient(clientOptions);
        CompletableFuture future = new CompletableFuture();
        this.locator.deployJerseyVerticle().then(id -> {
            future.complete(id);
            return null;
        }).otherwise(t -> {
            future.completeExceptionally((Throwable)t);
            return null;
        });
        this.deploymentID = (String)future.get(10L, TimeUnit.SECONDS);
    }

    protected void tearDown() throws Exception {
        this.httpClient.close();
        this.locator.tearDown();
        super.tearDown();
    }

    protected Promise<Void> onRejected(Throwable t) {
        t.printStackTrace();
        this.fail();
        return null;
    }

    protected WhenHttpClient getWhenHttpClient() {
        return this.locator.getWhenHttpClient();
    }
}

