/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.impl.DefaultJerseyOptions;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class DefaultJerseyOptionsTest {
    @Mock
    private Vertx vertx;
    @Mock
    private Context context;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private JsonObject config = new JsonObject();
    private DefaultJerseyOptions options;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.vertx.getOrCreateContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.context.config()).thenReturn((Object)this.config);
        this.options = new DefaultJerseyOptions(this.vertx);
    }

    @Test
    public void testGetBaseUri() throws Exception {
        String expected = "/";
        URI uri = this.options.getBaseUri();
        Assert.assertEquals((Object)expected, (Object)uri.getPath());
        expected = "test/base/path";
        this.config.put("base_path", expected);
        expected = expected + "/";
        uri = this.options.getBaseUri();
        Assert.assertEquals((Object)expected, (Object)uri.getPath());
    }

    @Test
    public void testGetMaxBodySize() throws Exception {
        int expected = 1024000;
        int maxBodySize = this.options.getMaxBodySize();
        Assert.assertEquals((long)expected, (long)maxBodySize);
        expected = 12;
        this.config.put("max_body_size", Integer.valueOf(expected));
        maxBodySize = this.options.getMaxBodySize();
        Assert.assertEquals((long)expected, (long)maxBodySize);
    }

    @Test
    public void testGetPackages() throws Exception {
        String package1 = "com.englishtown.vertx.jersey.resources1";
        String package2 = "com.englishtown.vertx.jersey.resources2";
        this.config.put("resources", new JsonArray().add(package1));
        this.config.put("packages", new JsonArray().add(package2));
        List packages = this.options.getPackages();
        Assert.assertNotNull((Object)packages);
        Assert.assertEquals((long)2L, (long)packages.size());
        Assert.assertEquals((Object)package1, packages.get(0));
        Assert.assertEquals((Object)package2, packages.get(1));
    }

    @Test
    public void testGetComponents() throws Exception {
        this.config.put("components", new JsonArray().add(MyObj.class.getName()));
        this.config.put("features", new JsonArray().add(MyBinder.class.getName()));
        Set instances = this.options.getComponents();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        Assert.assertTrue((boolean)instances.contains(MyObj.class));
        Assert.assertTrue((boolean)instances.contains(MyBinder.class));
    }

    @Test(expected=RuntimeException.class)
    public void testGetComponents_Fail() throws Exception {
        this.config.put("components", new JsonArray().add(MyObj.class.getName() + ".invalid"));
        this.options.getComponents();
        Assert.fail();
    }

    @Test
    public void testGetInstances() throws Exception {
        this.config.put("instances", new JsonArray().add(MyObj.class.getName()));
        this.config.put("binders", new JsonArray().add(MyBinder.class.getName()));
        Set instances = this.options.getInstances();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)2L, (long)instances.size());
        ArrayList list = new ArrayList(instances);
        Assert.assertThat(list.get(0), (Matcher)CoreMatchers.instanceOf(MyObj.class));
        Assert.assertThat(list.get(1), (Matcher)CoreMatchers.instanceOf(MyBinder.class));
    }

    @Test(expected=RuntimeException.class)
    public void testGetInstances_Fail() throws Exception {
        this.config.put("instances", new JsonArray().add(MyObj.class.getName() + ".invalid"));
        this.options.getInstances();
        Assert.fail();
    }

    @Test
    public void testGetProperties() throws Exception {
        JsonObject props = new JsonObject().put("prop1", "a");
        this.config.put("properties", props);
        Assert.assertEquals((Object)props.getMap(), (Object)this.options.getProperties());
    }

    @Test
    public void testGetProperties_Resource_Config() throws Exception {
        JsonObject rc = new JsonObject().put("prop1", "a");
        this.config.put("resource_config", rc);
        Assert.assertEquals((Object)rc.getMap(), (Object)this.options.getProperties());
    }

    @Test
    public void testGetProperties_Both() throws Exception {
        JsonObject props = new JsonObject().put("prop1", "a");
        JsonObject rc = new JsonObject().put("prop2", "b");
        this.config.put("properties", props);
        this.config.put("resource_config", rc);
        Map map = this.options.getProperties();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"a", map.get("prop1"));
        Assert.assertEquals((Object)"b", map.get("prop2"));
    }

    @Test
    public void testGetProperties_Null() throws Exception {
        JsonObject rc = new JsonObject().put("prop1", "a");
        this.config.put("resource_config", rc);
        Assert.assertEquals((Object)rc.getMap(), (Object)this.options.getProperties());
    }

    public static class MyBinder
    extends AbstractBinder {
        protected void configure() {
        }

        public int hashCode() {
            return 2;
        }
    }

    public static class MyObj {
        public int hashCode() {
            return 1;
        }
    }
}

