/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.JerseyServer;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.inject.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.hk2.api.ServiceLocatorFactory;

public class DefaultJerseyServer
implements JerseyServer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJerseyServer.class);
    private JerseyHandler jerseyHandler;
    private VertxContainer container;
    private final Provider<JerseyServerOptions> optionsProvider;
    private Handler<HttpServer> setupHandler;
    private HttpServer server;

    @Inject
    public DefaultJerseyServer(JerseyHandler jerseyHandler, VertxContainer container, Provider<JerseyServerOptions> optionsProvider) {
        this.jerseyHandler = jerseyHandler;
        this.container = container;
        this.optionsProvider = optionsProvider;
    }

    @Override
    public void start(@Nullable JerseyServerOptions options, @Nullable JerseyOptions jerseyOptions, @Nullable Handler<AsyncResult<HttpServer>> doneHandler) {
        HttpServerOptions serverOptions;
        if (options == null) {
            options = (JerseyServerOptions)this.optionsProvider.get();
        }
        if ((serverOptions = options.getServerOptions()) == null) {
            throw new IllegalArgumentException("http server options cannot be null");
        }
        if (jerseyOptions != null) {
            this.container.setOptions(jerseyOptions);
        }
        this.jerseyHandler.setContainer(this.container);
        this.server = this.container.getVertx().createHttpServer(serverOptions);
        this.server.requestHandler(this.jerseyHandler::handle);
        if (this.setupHandler != null) {
            this.setupHandler.handle((Object)this.server);
        }
        this.container.getVertx().executeBlocking(future -> {
            this.container.start();
            future.complete();
        }, result -> {
            if (result.failed()) {
                logger.error((Object)"Failed to start the jersey container", result.cause());
                if (doneHandler != null) {
                    doneHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
                }
                return;
            }
            this.server.listen(ar -> {
                String listenPath = (serverOptions.isSsl() ? "https" : "http") + "://" + serverOptions.getHost() + ":" + serverOptions.getPort();
                if (ar.succeeded()) {
                    logger.info((Object)("Http server listening for " + listenPath));
                } else {
                    logger.error((Object)("Failed to start http server listening for " + listenPath), ar.cause());
                }
                if (doneHandler != null) {
                    doneHandler.handle(ar);
                }
            });
        });
    }

    @Override
    public void setupHandler(Handler<HttpServer> handler) {
        this.setupHandler = handler;
    }

    @Override
    public JerseyHandler getHandler() {
        return this.jerseyHandler;
    }

    @Override
    public HttpServer getHttpServer() {
        return this.server;
    }

    @Override
    public void stop() {
        if (this.container != null) {
            this.container.stop();
            this.container = null;
        }
        if (this.jerseyHandler != null && this.jerseyHandler.getDelegate() != null) {
            ServiceLocatorFactory.getInstance().destroy(this.jerseyHandler.getDelegate().getServiceLocator());
            this.jerseyHandler = null;
        }
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

