/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.guice;

import com.englishtown.vertx.guice.GuiceJerseyServer;
import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.JerseyServerOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class GuiceJerseyServerTest {
    GuiceJerseyServer server;
    @Mock
    JerseyHandler handler;
    @Mock
    VertxContainer container;
    @Mock
    JerseyServerOptions options;
    @Mock
    ServiceLocator locator;
    @Mock
    DynamicConfigurationService dcs;
    @Mock
    DynamicConfiguration dc;
    @Mock
    Injector injector;
    @Mock
    GuiceIntoHK2Bridge bridge;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)((GuiceIntoHK2Bridge)this.locator.getService((Class)Matchers.eq(GuiceIntoHK2Bridge.class), new Annotation[0]))).thenReturn((Object)this.bridge);
        Mockito.when((Object)((DynamicConfigurationService)this.locator.getService((Class)Matchers.eq(DynamicConfigurationService.class), new Annotation[0]))).thenReturn((Object)this.dcs);
        Mockito.when((Object)this.dcs.createDynamicConfiguration()).thenReturn((Object)this.dc);
        Key key = Key.get((TypeLiteral)new TypeLiteral<Set<ContainerRequestFilter>>(){});
        LinkedHashSet<ContainerRequestFilter> set = new LinkedHashSet<ContainerRequestFilter>();
        set.add((ContainerRequestFilter)Mockito.mock(ContainerRequestFilter.class));
        Mockito.when((Object)this.injector.getInstance((Key)Matchers.any(key.getClass()))).thenReturn(set);
        this.server = new GuiceJerseyServer(this.handler, this.container, () -> this.options, this.locator, this.injector);
    }

    @Test
    public void testInjectMultiBindings() throws Exception {
        Key key = Key.get((TypeLiteral)new TypeLiteral<Set<ContainerRequestFilter>>(){});
        Set requestFilters = (Set)this.injector.getInstance(key);
        Assert.assertEquals((long)1L, (long)requestFilters.size());
        ((Injector)Mockito.verify((Object)this.injector, (VerificationMode)Mockito.times((int)2))).getInstance((Key)Matchers.eq((Object)key));
        key = Key.get((TypeLiteral)new TypeLiteral<Set<ContainerResponseFilter>>(){});
        ((Injector)Mockito.verify((Object)this.injector)).getInstance((Key)Matchers.eq((Object)key));
        key = Key.get((TypeLiteral)new TypeLiteral<Set<ReaderInterceptor>>(){});
        ((Injector)Mockito.verify((Object)this.injector)).getInstance((Key)Matchers.eq((Object)key));
        key = Key.get((TypeLiteral)new TypeLiteral<Set<WriterInterceptor>>(){});
        ((Injector)Mockito.verify((Object)this.injector)).getInstance((Key)Matchers.eq((Object)key));
        key = Key.get((TypeLiteral)new TypeLiteral<Set<ModelProcessor>>(){});
        ((Injector)Mockito.verify((Object)this.injector)).getInstance((Key)Matchers.eq((Object)key));
    }
}

