/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.hk2;

import com.englishtown.vertx.hk2.HK2JerseyBinder;
import com.englishtown.vertx.jersey.inject.VertxPostResponseProcessor;
import com.englishtown.vertx.jersey.inject.VertxRequestProcessor;
import com.englishtown.vertx.jersey.inject.VertxResponseProcessor;
import java.util.Arrays;
import java.util.List;
import org.glassfish.hk2.api.IterableProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class HK2JerseyBinderTest {
    @Mock
    IterableProvider<VertxRequestProcessor> requestProcessorProviders;
    @Mock
    IterableProvider<VertxResponseProcessor> responseProcessorProviders;
    @Mock
    IterableProvider<VertxPostResponseProcessor> postResponseProcessorProviders;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Test
    public void testVertxRequestProcessorFactory() {
        List<VertxRequestProcessor> list = Arrays.asList((VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class), (VertxRequestProcessor)Mockito.mock(VertxRequestProcessor.class));
        Mockito.when((Object)this.requestProcessorProviders.iterator()).thenReturn(list.iterator());
        HK2JerseyBinder.VertxRequestProcessorFactory factory = new HK2JerseyBinder.VertxRequestProcessorFactory(this.requestProcessorProviders);
        List result = factory.provide();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        factory.dispose(result);
    }

    @Test
    public void testVertxResponseProcessorFactory() {
        List<VertxResponseProcessor> list = Arrays.asList((VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class), (VertxResponseProcessor)Mockito.mock(VertxResponseProcessor.class));
        Mockito.when((Object)this.responseProcessorProviders.iterator()).thenReturn(list.iterator());
        HK2JerseyBinder.VertxResponseProcessorFactory factory = new HK2JerseyBinder.VertxResponseProcessorFactory(this.responseProcessorProviders);
        List result = factory.provide();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        factory.dispose(result);
    }

    @Test
    public void testVertxPostResponseProcessorFactory() {
        List<VertxPostResponseProcessor> list = Arrays.asList((VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class), (VertxPostResponseProcessor)Mockito.mock(VertxPostResponseProcessor.class));
        Mockito.when((Object)this.postResponseProcessorProviders.iterator()).thenReturn(list.iterator());
        HK2JerseyBinder.VertxPostResponseProcessorFactory factory = new HK2JerseyBinder.VertxPostResponseProcessorFactory(this.postResponseProcessorProviders);
        List result = factory.provide();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        factory.dispose(result);
    }
}

