/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.impl;

import com.englishtown.vertx.jersey.ApplicationConfigurator;
import com.englishtown.vertx.jersey.ApplicationHandlerDelegate;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.impl.DefaultApplicationHandlerDelegate;
import com.englishtown.vertx.jersey.inject.InternalVertxJerseyBinder;
import com.englishtown.vertx.jersey.inject.Nullable;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Application;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.jvnet.hk2.annotations.Optional;

public class DefaultVertxContainer
implements VertxContainer {
    private final Vertx vertx;
    private final ServiceLocator locator;
    private final ApplicationConfigurator configurator;
    private JerseyOptions options;
    private ApplicationHandlerDelegate applicationHandlerDelegate;
    private boolean started;

    @Inject
    public DefaultVertxContainer(Vertx vertx, JerseyOptions options, @Optional @Nullable ServiceLocator locator, @Optional @Nullable ApplicationConfigurator configurator) {
        this.vertx = vertx;
        this.options = options;
        this.locator = locator;
        this.configurator = configurator;
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        ApplicationHandler handler = this.getApplicationHandler();
        if (handler == null) {
            throw new IllegalStateException("ApplicationHandler cannot be null");
        }
        handler.onStartup((Container)this);
        this.started = true;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.getApplicationHandler().onShutdown((Container)this);
        this.applicationHandlerDelegate = null;
        this.started = false;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    @Override
    public JerseyOptions getOptions() {
        return this.options;
    }

    @Override
    public VertxContainer setOptions(JerseyOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public ApplicationHandlerDelegate getApplicationHandlerDelegate() {
        if (this.applicationHandlerDelegate == null) {
            ResourceConfig rc = this.createConfiguration();
            ApplicationHandler applicationHandler = new ApplicationHandler((Application)rc, null, this.locator);
            this.applicationHandlerDelegate = new DefaultApplicationHandlerDelegate(applicationHandler);
        }
        return this.applicationHandlerDelegate;
    }

    public ResourceConfig getConfiguration() {
        ApplicationHandler handler = this.getApplicationHandler();
        return handler == null ? null : handler.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.getApplicationHandlerDelegate().getApplicationHandler();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        ApplicationHandler applicationHandler = new ApplicationHandler((Application)configuration, null, this.locator);
        this.applicationHandlerDelegate = new DefaultApplicationHandlerDelegate(applicationHandler);
        this.getApplicationHandler().onReload((Container)this);
        applicationHandler.onStartup((Container)this);
    }

    protected ResourceConfig createConfiguration() {
        Map<String, Object> properties;
        boolean hasComponents;
        ResourceConfig rc = new ResourceConfig();
        List<String> packages = this.options.getPackages();
        Set<Class<?>> components = this.options.getComponents();
        boolean hasPackages = packages != null && !packages.isEmpty();
        boolean bl = hasComponents = components != null && !components.isEmpty();
        if (!hasComponents && !hasPackages) {
            throw new IllegalStateException("At least one resource package name or component must be specified");
        }
        if (hasPackages) {
            rc.packages(packages.toArray(new String[packages.size()]));
        }
        if (hasComponents) {
            rc.registerClasses(components);
        }
        rc.register((Object)new InternalVertxJerseyBinder(this.vertx));
        Set<Object> instances = this.options.getInstances();
        if (instances != null) {
            rc.registerInstances(instances);
        }
        if ((properties = this.options.getProperties()) != null) {
            rc.addProperties(properties);
        }
        if (this.configurator != null) {
            rc = this.configurator.configure(rc);
        }
        return rc;
    }
}

