/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.promises.integration;

import com.englishtown.promises.When;
import com.englishtown.promises.WhenFactory;
import com.englishtown.vertx.guice.GuiceVertxBinder;
import com.englishtown.vertx.guice.WhenGuiceJerseyBinder;
import com.englishtown.vertx.hk2.HK2VertxBinder;
import com.englishtown.vertx.hk2.WhenHK2JerseyBinder;
import com.englishtown.vertx.jersey.JerseyHandler;
import com.englishtown.vertx.jersey.JerseyOptions;
import com.englishtown.vertx.jersey.JerseyServer;
import com.englishtown.vertx.jersey.VertxContainer;
import com.englishtown.vertx.jersey.impl.DefaultJerseyHandler;
import com.englishtown.vertx.jersey.impl.DefaultJerseyOptions;
import com.englishtown.vertx.jersey.impl.DefaultJerseyServer;
import com.englishtown.vertx.jersey.impl.DefaultVertxContainer;
import com.englishtown.vertx.jersey.inject.ContainerResponseWriterProvider;
import com.englishtown.vertx.jersey.inject.impl.VertxResponseWriterProvider;
import com.englishtown.vertx.jersey.promises.WhenJerseyServer;
import com.englishtown.vertx.jersey.promises.impl.DefaultWhenJerseyServer;
import com.englishtown.vertx.promises.guice.GuiceWhenBinder;
import com.englishtown.vertx.promises.hk2.HK2WhenBinder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.junit.Test;

public abstract class PromisesIntegrationTests
extends VertxTestBase {
    private String host = "localhost";
    private int port = 8080;
    private JerseyServer jerseyServer;

    public void setUp() throws Exception {
        super.setUp();
        this.createServer(this.host, this.port);
    }

    protected void tearDown() throws Exception {
        if (this.jerseyServer != null) {
            this.jerseyServer.close();
            this.jerseyServer = null;
        }
        super.tearDown();
    }

    private void createServer(String host, int port) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx.runOnContext(aVoid -> {
            this.vertx.getOrCreateContext().config().put("jersey", new JsonObject().put("host", host).put("port", Integer.valueOf(port)).put("resources", new JsonArray().add("com.englishtown.vertx.jersey.promises.integration.resources")));
            this.getWhenJerseyServer().createServer().then(value -> {
                this.jerseyServer = value;
                latch.countDown();
                return null;
            }).otherwise(t -> {
                latch.countDown();
                t.printStackTrace();
                this.fail();
                return null;
            });
        });
        latch.await(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testCreateServer() throws Exception {
        HttpClientOptions options = new HttpClientOptions().setConnectTimeout(300);
        this.vertx.createHttpClient(options).request(HttpMethod.GET, this.port, this.host, "/integration/test", response -> {
            this.assertEquals(200L, response.statusCode());
            this.testComplete();
        }).exceptionHandler(t -> this.fail(t.getMessage())).end();
        this.await();
    }

    @Test
    public void testCreateMultipleServers() throws Exception {
        int port2 = 8081;
        this.createServer(this.host, port2);
        HttpClientOptions options = new HttpClientOptions().setConnectTimeout(300);
        this.vertx.createHttpClient(options).request(HttpMethod.GET, this.port, this.host, "/integration/test", response -> {
            this.assertEquals(200L, response.statusCode());
            this.vertx.createHttpClient(options).request(HttpMethod.GET, port2, this.host, "/integration/test", response2 -> {
                this.assertEquals(200L, response2.statusCode());
                this.testComplete();
            }).exceptionHandler(t -> this.fail(t.getMessage())).end();
        }).exceptionHandler(t -> this.fail(t.getMessage())).end();
        this.await();
    }

    protected abstract WhenJerseyServer getWhenJerseyServer();

    public static class Simple
    extends PromisesIntegrationTests {
        @Override
        protected WhenJerseyServer getWhenJerseyServer() {
            VertxResponseWriterProvider provider = new VertxResponseWriterProvider(this.vertx, new ArrayList(), new ArrayList());
            DefaultJerseyOptions options = new DefaultJerseyOptions(this.vertx);
            DefaultVertxContainer container = new DefaultVertxContainer(this.vertx, (JerseyOptions)options, null, null);
            DefaultJerseyHandler handler = new DefaultJerseyHandler(() -> Simple.lambda$getWhenJerseyServer$0((VertxContainer)container), (ContainerResponseWriterProvider)provider, new ArrayList());
            DefaultJerseyServer server = new DefaultJerseyServer((JerseyHandler)handler, (VertxContainer)container, () -> options);
            When when = WhenFactory.createSync();
            return new DefaultWhenJerseyServer(this.vertx, () -> Simple.lambda$getWhenJerseyServer$2((JerseyServer)server), when);
        }

        private static /* synthetic */ JerseyServer lambda$getWhenJerseyServer$2(JerseyServer server) {
            return server;
        }

        private static /* synthetic */ VertxContainer lambda$getWhenJerseyServer$0(VertxContainer container) {
            return container;
        }
    }

    public static class HK2
    extends PromisesIntegrationTests {
        private ServiceLocator locator;

        @Override
        protected WhenJerseyServer getWhenJerseyServer() {
            if (this.locator == null) {
                this.locator = ServiceLocatorUtilities.bind((Binder[])new Binder[]{new WhenHK2JerseyBinder(), new HK2WhenBinder(), new HK2VertxBinder(this.vertx)});
            }
            return (WhenJerseyServer)this.locator.getService(WhenJerseyServer.class, new Annotation[0]);
        }

        @Override
        protected void tearDown() throws Exception {
            super.tearDown();
            if (this.locator != null) {
                this.locator.shutdown();
                this.locator = null;
            }
        }
    }

    public static class Guice
    extends PromisesIntegrationTests {
        private Injector injector;

        @Override
        protected WhenJerseyServer getWhenJerseyServer() {
            if (this.injector == null) {
                this.injector = com.google.inject.Guice.createInjector((Module[])new Module[]{new WhenGuiceJerseyBinder(), new GuiceWhenBinder(), new GuiceVertxBinder(this.vertx)});
            }
            return (WhenJerseyServer)this.injector.getInstance(WhenJerseyServer.class);
        }
    }
}

