/*
 * Decompiled with CFR 0.152.
 */
package com.englishtown.vertx.jersey.features.swagger.internal;

import com.englishtown.vertx.jersey.features.swagger.internal.SwaggerServletConfig;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class SwaggerServletConfigTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    private final String configId = "configId";
    private final String scannerId = "scannerId";
    private final String contextId = "contextId";
    private SwaggerServletConfig servletConfig;
    private Map<String, Object> properties = new HashMap<String, Object>();
    @Mock
    private ServletContext context;
    @Mock
    private Configuration configuration;

    @Before
    public void setUp() throws Exception {
        this.properties.put("swagger.config.id", "configId");
        this.properties.put("swagger.scanner.id", "scannerId");
        this.properties.put("swagger.context.id", "contextId");
        Mockito.when((Object)this.context.getContextPath()).thenReturn((Object)"basePath");
        Mockito.when((Object)this.configuration.getProperties()).thenReturn(this.properties);
    }

    @Test
    public void testInitParamsCreation() throws Exception {
        this.servletConfig = new SwaggerServletConfig(this.context, this.configuration);
        Assert.assertNotNull((Object)this.servletConfig);
        Assert.assertEquals((Object)"configId", (Object)this.servletConfig.getInitParameter("swagger.config.id"));
        Assert.assertEquals((Object)"scannerId", (Object)this.servletConfig.getInitParameter("swagger.scanner.id"));
        Assert.assertEquals((Object)"contextId", (Object)this.servletConfig.getInitParameter("swagger.context.id"));
    }

    @Test
    public void testInitParamsCreation_nullProperty() throws Exception {
        this.properties.put("swagger.config.id", null);
        this.servletConfig = new SwaggerServletConfig(this.context, this.configuration);
        Assert.assertNotNull((Object)this.servletConfig);
        Assert.assertNull((Object)this.servletConfig.getInitParameter("swagger.config.id"));
    }

    @Test
    public void testInitParamsCreation_ignoredProperty() throws Exception {
        String ignoredKey = "ignore";
        this.properties.put(ignoredKey, "test-value");
        this.servletConfig = new SwaggerServletConfig(this.context, this.configuration);
        Assert.assertNotNull((Object)this.servletConfig);
        Assert.assertNull((Object)this.servletConfig.getInitParameter(ignoredKey));
    }

    @Test
    public void testGetInitParameterNames() throws Exception {
        this.servletConfig = new SwaggerServletConfig(this.context, this.configuration);
        Enumeration paramNames = this.servletConfig.getInitParameterNames();
        Assert.assertNotNull((Object)paramNames);
        while (paramNames.hasMoreElements()) {
            Assert.assertTrue((boolean)this.properties.keySet().contains(paramNames.nextElement()));
        }
    }
}

