/*
 * Decompiled with CFR 0.152.
 */
package com.nautilus.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nautilus.serialization.EventSerializationHandler;
import com.nautilus.serialization.SerializationException;
import io.appform.nautilus.funnel.model.session.SessionActivitySet;
import java.util.List;

public class JacksonJsonSerializationHandler
implements EventSerializationHandler {
    public static final JacksonJsonSerializationHandler INSTANCE = new JacksonJsonSerializationHandler();
    private final ObjectMapper mapper = new ObjectMapper();

    private JacksonJsonSerializationHandler() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    @Override
    public byte[] serialize(List<SessionActivitySet> sessionActivitySets) throws SerializationException {
        try {
            return this.mapper.writeValueAsBytes(sessionActivitySets);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing document: " + e.getLocalizedMessage(), e);
        }
    }
}

