/*
 * Decompiled with CFR 0.152.
 */
package com.nautilus.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.nautilus.cluster.NautilusCluster;
import com.nautilus.cluster.NautilusClusterMember;
import com.nautilus.config.NautilusClientConfig;
import com.nautilus.selectors.NautilusTarget;
import com.nautilus.selectors.RandomSelector;
import com.nautilus.senders.NautilusHttpClient;
import com.nautilus.serialization.EventSerializationHandler;
import com.nautilus.serialization.JacksonJsonSerializationHandler;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Response;
import feign.slf4j.Slf4jLogger;
import io.appform.nautilus.funnel.model.session.SessionActivitySet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NautilusClient {
    private static final Logger log = LoggerFactory.getLogger(NautilusClient.class);
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();
    private NautilusCluster nautilusCluster;
    private NautilusHttpClient httpClient;
    private EventSerializationHandler serializationHandler = JacksonJsonSerializationHandler.INSTANCE;
    private ObjectMapper objectMapper;

    public NautilusClient(NautilusClientConfig config, ObjectMapper objectMapper) throws Exception {
        this.nautilusCluster = new NautilusCluster(config, new RandomSelector());
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectionPool(new ConnectionPool(config.getMaxConnections(), config.getKeepAliveTimeMillis()));
        this.httpClient = (NautilusHttpClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(okHttpClient)).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(new NautilusTarget<NautilusHttpClient>(NautilusHttpClient.class, "nautilus", this.nautilusCluster));
        this.objectMapper = objectMapper;
    }

    public void send(String tenant, List<SessionActivitySet> sessionActivitySets) throws Exception {
        Preconditions.checkNotNull((Object)tenant);
        this.sendToNautilus(tenant, sessionActivitySets);
    }

    public void close() throws Exception {
        this.nautilusCluster.stop();
    }

    private void sendToNautilus(String tenant, List<SessionActivitySet> sessionActivitySets) {
        block6: {
            NautilusClusterMember clusterMember = this.nautilusCluster.member();
            Preconditions.checkNotNull((Object)clusterMember, (Object)"No members found in nautilus cluster");
            try {
                Response response;
                try {
                    response = this.httpClient.send(tenant, this.objectMapper.writeValueAsBytes(sessionActivitySets));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error parsing sessionActivitySet : " + sessionActivitySets.toString());
                }
                if (this.is2XX(response.status())) {
                    log.info("table={} messages_sent host={} port={}", new Object[]{tenant, clusterMember.getHost(), clusterMember.getPort()});
                    break block6;
                }
                if (response.status() == 400) {
                    log.error("table={} host={} port={} statusCode={}", new Object[]{tenant, clusterMember.getHost(), clusterMember.getPort(), response.status()});
                    break block6;
                }
                throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", tenant, response.status(), response.reason()));
            }
            catch (FeignException e) {
                log.error("table={} msg=event_publish_failed", (Object)new Object[]{tenant}, (Object)e);
            }
        }
    }

    private boolean is2XX(int status) {
        return status / 100 == 2;
    }

    public NautilusCluster getNautilusCluster() {
        return this.nautilusCluster;
    }

    public NautilusHttpClient getHttpClient() {
        return this.httpClient;
    }

    public EventSerializationHandler getSerializationHandler() {
        return this.serializationHandler;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setNautilusCluster(NautilusCluster nautilusCluster) {
        this.nautilusCluster = nautilusCluster;
    }

    public void setHttpClient(NautilusHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setSerializationHandler(EventSerializationHandler serializationHandler) {
        this.serializationHandler = serializationHandler;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NautilusClient)) {
            return false;
        }
        NautilusClient other = (NautilusClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NautilusCluster this$nautilusCluster = this.getNautilusCluster();
        NautilusCluster other$nautilusCluster = other.getNautilusCluster();
        if (this$nautilusCluster == null ? other$nautilusCluster != null : !this$nautilusCluster.equals(other$nautilusCluster)) {
            return false;
        }
        NautilusHttpClient this$httpClient = this.getHttpClient();
        NautilusHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        EventSerializationHandler this$serializationHandler = this.getSerializationHandler();
        EventSerializationHandler other$serializationHandler = other.getSerializationHandler();
        if (this$serializationHandler == null ? other$serializationHandler != null : !this$serializationHandler.equals(other$serializationHandler)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NautilusClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NautilusCluster $nautilusCluster = this.getNautilusCluster();
        result = result * 59 + ($nautilusCluster == null ? 43 : $nautilusCluster.hashCode());
        NautilusHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        EventSerializationHandler $serializationHandler = this.getSerializationHandler();
        result = result * 59 + ($serializationHandler == null ? 43 : $serializationHandler.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "NautilusClient(nautilusCluster=" + this.getNautilusCluster() + ", httpClient=" + this.getHttpClient() + ", serializationHandler=" + this.getSerializationHandler() + ", objectMapper=" + this.getObjectMapper() + ")";
    }
}

