/*
 * Decompiled with CFR 0.152.
 */
package com.nautilus.cluster;

import com.nautilus.cluster.ClusterStatusUpdater;
import com.nautilus.cluster.NautilusClusterMember;
import com.nautilus.cluster.NautilusClusterStatus;
import com.nautilus.config.NautilusClientConfig;
import com.nautilus.selectors.MemberSelector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NautilusCluster {
    private static final Logger log = LoggerFactory.getLogger(NautilusCluster.class);
    private final MemberSelector selector;
    private final ScheduledFuture<?> future;
    private NautilusClientConfig clientConfig;
    private ScheduledExecutorService executorService;
    private AtomicReference<NautilusClusterStatus> status = new AtomicReference();

    public NautilusCluster(NautilusClientConfig config, MemberSelector selector) throws Exception {
        this.selector = selector;
        this.clientConfig = config;
        this.executorService = Executors.newScheduledThreadPool(1);
        ClusterStatusUpdater updater = ClusterStatusUpdater.create(config, this.status);
        updater.loadClusterData();
        this.future = this.executorService.scheduleWithFixedDelay(updater, config.getRefreshIntervalSecs(), config.getRefreshIntervalSecs(), TimeUnit.SECONDS);
    }

    public NautilusClusterMember member() {
        if (null == this.status || this.status.get() == null || this.status.get().getMembers().isEmpty()) {
            return new NautilusClusterMember(this.clientConfig.getHost(), this.clientConfig.getPort());
        }
        return this.selector.selectMember(this.status.get().getMembers());
    }

    public void stop() {
        log.info("table={} shutting_down_cluster_status_checker", new Object[]{this.clientConfig.getTable()});
        this.future.cancel(true);
        while (!this.future.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error("table={} interrupted", (Object)new Object[]{this.clientConfig.getTable()}, (Object)e);
            }
            log.info("table={} waiting_for_checker_to_stop", new Object[]{this.clientConfig.getTable()});
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("table={} executor_service_termination_exception", (Object)new Object[]{this.clientConfig.getTable()}, (Object)e);
        }
        this.executorService.shutdownNow();
        log.info("table={} cluster_status_checker_shutdown_complete", new Object[]{this.clientConfig.getTable()});
    }
}

