/*
 * Decompiled with CFR 0.152.
 */
package com.nautilus.cluster;

import com.nautilus.cluster.NautilusClusterHttpClient;
import com.nautilus.cluster.NautilusClusterStatus;
import com.nautilus.config.NautilusClientConfig;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatusUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterStatusUpdater.class.getSimpleName());
    private static final JacksonDecoder decoder = new JacksonDecoder();
    private static final JacksonEncoder encoder = new JacksonEncoder();
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();
    private final NautilusClusterHttpClient httpClient;
    private AtomicReference<NautilusClusterStatus> status;

    private ClusterStatusUpdater(AtomicReference<NautilusClusterStatus> status, NautilusClusterHttpClient httpClient) {
        this.status = status;
        this.httpClient = httpClient;
    }

    static ClusterStatusUpdater create(NautilusClientConfig config, AtomicReference<NautilusClusterStatus> status) {
        NautilusClusterHttpClient httpClient = (NautilusClusterHttpClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).client((Client)new OkHttpClient()).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(NautilusClusterHttpClient.class, String.format("http://%s:%s", config.getHost(), config.getPort()));
        return new ClusterStatusUpdater(status, httpClient);
    }

    @Override
    public void run() {
    }

    void loadClusterData() {
        try {
            logger.trace("Initiating data get");
            this.status.set(this.httpClient.load());
        }
        catch (Exception e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof FeignException) {
                FeignException feignException = (FeignException)e;
                logger.error("Error getting status:{} - {}", (Object)feignException.status(), (Object)feignException.getMessage());
            }
            logger.error("Error getting cluster data: ", (Throwable)e);
        }
    }
}

