/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http.executor;

import com.platform.http.Endpoint;
import com.platform.http.ServiceEndpointProvider;
import java.util.Optional;
import okhttp3.HttpUrl;

public interface HttpUtils {
    public static HttpUrl getSecureHttpUrl(ServiceEndpointProvider endpointProvider, String url) {
        Optional<Endpoint> endpointOptional = endpointProvider.endpoint();
        if (!endpointOptional.isPresent()) {
            throw new RuntimeException("Client endpoints have not been configured");
        }
        return endpointOptional.get().secureUrl(url);
    }

    public static HttpUrl getHttpUrl(ServiceEndpointProvider endpointProvider, String url) {
        Optional<Endpoint> endpointOptional = endpointProvider.endpoint();
        if (!endpointOptional.isPresent()) {
            throw new RuntimeException("Client endpoints have not been configured");
        }
        return endpointOptional.get().url(url);
    }

    public static <T> void checkNull(T t, String message) {
        if (t == null) {
            throw new RuntimeException(message);
        }
    }

    public static <T1, T2> void checkNull(T1 t, T2 t2, String message) {
        if (t == null && t2 == null) {
            throw new RuntimeException(message);
        }
    }
}

