/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.platform.http.ServiceEndpointProvider;
import com.platform.http.executor.BaseHttpExecutor;
import com.platform.http.executor.Consumer;
import com.platform.http.executor.ExtractedResponse;
import com.platform.http.executor.HeaderPair;
import com.platform.http.executor.HttpData;
import com.platform.http.executor.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPutExecutor<T>
extends BaseHttpExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(HttpPutExecutor.class);

    public HttpPutExecutor(OkHttpClient client, String command, ServiceEndpointProvider endpointProvider, String url, List<HeaderPair> headers, HttpData httpData, ObjectMapper mapper, Class<T> responseType, boolean secure, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        super(client, command, endpointProvider, url, headers, httpData, mapper, responseType, secure, exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    @Override
    public void preconditions() {
        super.preconditions();
        HttpUtils.checkNull(this.httpData, "putData cant be null");
    }

    @Override
    public Request getRequest(HttpUrl httpUrl) throws JsonProcessingException {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).put(this.getRequestBody());
        if (this.headers != null) {
            this.headers.forEach(h -> requestBuilder.header(h.getName(), h.getValue()));
        }
        return requestBuilder.build();
    }

    public static <T> HttpPutExecutorBuilder<T> builder() {
        return new HttpPutExecutorBuilder();
    }

    @Override
    public String toString() {
        return "HttpPutExecutor(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpPutExecutor)) {
            return false;
        }
        HttpPutExecutor other = (HttpPutExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpPutExecutor;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class HttpPutExecutorBuilder<T> {
        private OkHttpClient client;
        private String command;
        private ServiceEndpointProvider endpointProvider;
        private String url;
        private ArrayList<HeaderPair> headers;
        private HttpData httpData;
        private ObjectMapper mapper;
        private Class<T> responseType;
        private boolean secure;
        private Consumer<Exception, T> exceptionConsumer;
        private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
        private TypeReference<T> responseTypeReference;

        HttpPutExecutorBuilder() {
        }

        public HttpPutExecutorBuilder<T> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HttpPutExecutorBuilder<T> command(String command) {
            this.command = command;
            return this;
        }

        public HttpPutExecutorBuilder<T> endpointProvider(ServiceEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        public HttpPutExecutorBuilder<T> url(String url) {
            this.url = url;
            return this;
        }

        public HttpPutExecutorBuilder<T> header(HeaderPair header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public HttpPutExecutorBuilder<T> headers(Collection<? extends HeaderPair> headers) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public HttpPutExecutorBuilder<T> clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public HttpPutExecutorBuilder<T> httpData(HttpData httpData) {
            this.httpData = httpData;
            return this;
        }

        public HttpPutExecutorBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public HttpPutExecutorBuilder<T> responseType(Class<T> responseType) {
            this.responseType = responseType;
            return this;
        }

        public HttpPutExecutorBuilder<T> secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public HttpPutExecutorBuilder<T> exceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public HttpPutExecutorBuilder<T> nonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
            this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
            return this;
        }

        public HttpPutExecutorBuilder<T> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public HttpPutExecutor<T> build() {
            List<HeaderPair> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<HeaderPair>(this.headers));
                }
            }
            return new HttpPutExecutor<T>(this.client, this.command, this.endpointProvider, this.url, headers, this.httpData, this.mapper, this.responseType, this.secure, this.exceptionConsumer, this.nonSuccessResponseConsumer, this.responseTypeReference);
        }

        public String toString() {
            return "HttpPutExecutor.HttpPutExecutorBuilder(client=" + this.client + ", command=" + this.command + ", endpointProvider=" + this.endpointProvider + ", url=" + this.url + ", headers=" + this.headers + ", httpData=" + this.httpData + ", mapper=" + this.mapper + ", responseType=" + this.responseType + ", secure=" + this.secure + ", exceptionConsumer=" + this.exceptionConsumer + ", nonSuccessResponseConsumer=" + this.nonSuccessResponseConsumer + ", responseTypeReference=" + this.responseTypeReference + ")";
        }
    }
}

