/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http.executor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.platform.http.ServiceEndpointProvider;
import com.platform.http.executor.BaseHttpExecutor;
import com.platform.http.executor.Consumer;
import com.platform.http.executor.ExtractedResponse;
import com.platform.http.executor.HeaderPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetExecutor<T>
extends BaseHttpExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(HttpGetExecutor.class);

    public HttpGetExecutor(OkHttpClient client, String command, ServiceEndpointProvider endpointProvider, String url, List<HeaderPair> headers, ObjectMapper mapper, Class<T> responseType, boolean secure, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        super(client, command, endpointProvider, url, headers, null, mapper, responseType, secure, exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    @Override
    public Request getRequest(HttpUrl httpUrl) {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        if (this.headers != null) {
            this.headers.forEach(h -> requestBuilder.header(h.getName(), h.getValue()));
        }
        return requestBuilder.build();
    }

    public static <T> HttpGetExecutorBuilder<T> builder() {
        return new HttpGetExecutorBuilder();
    }

    @Override
    public String toString() {
        return "HttpGetExecutor(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpGetExecutor)) {
            return false;
        }
        HttpGetExecutor other = (HttpGetExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpGetExecutor;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class HttpGetExecutorBuilder<T> {
        private OkHttpClient client;
        private String command;
        private ServiceEndpointProvider endpointProvider;
        private String url;
        private ArrayList<HeaderPair> headers;
        private ObjectMapper mapper;
        private Class<T> responseType;
        private boolean secure;
        private Consumer<Exception, T> exceptionConsumer;
        private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
        private TypeReference<T> responseTypeReference;

        HttpGetExecutorBuilder() {
        }

        public HttpGetExecutorBuilder<T> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HttpGetExecutorBuilder<T> command(String command) {
            this.command = command;
            return this;
        }

        public HttpGetExecutorBuilder<T> endpointProvider(ServiceEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        public HttpGetExecutorBuilder<T> url(String url) {
            this.url = url;
            return this;
        }

        public HttpGetExecutorBuilder<T> header(HeaderPair header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public HttpGetExecutorBuilder<T> headers(Collection<? extends HeaderPair> headers) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public HttpGetExecutorBuilder<T> clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public HttpGetExecutorBuilder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public HttpGetExecutorBuilder<T> responseType(Class<T> responseType) {
            this.responseType = responseType;
            return this;
        }

        public HttpGetExecutorBuilder<T> secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public HttpGetExecutorBuilder<T> exceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public HttpGetExecutorBuilder<T> nonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
            this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
            return this;
        }

        public HttpGetExecutorBuilder<T> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public HttpGetExecutor<T> build() {
            List<HeaderPair> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<HeaderPair>(this.headers));
                }
            }
            return new HttpGetExecutor<T>(this.client, this.command, this.endpointProvider, this.url, headers, this.mapper, this.responseType, this.secure, this.exceptionConsumer, this.nonSuccessResponseConsumer, this.responseTypeReference);
        }

        public String toString() {
            return "HttpGetExecutor.HttpGetExecutorBuilder(client=" + this.client + ", command=" + this.command + ", endpointProvider=" + this.endpointProvider + ", url=" + this.url + ", headers=" + this.headers + ", mapper=" + this.mapper + ", responseType=" + this.responseType + ", secure=" + this.secure + ", exceptionConsumer=" + this.exceptionConsumer + ", nonSuccessResponseConsumer=" + this.nonSuccessResponseConsumer + ", responseTypeReference=" + this.responseTypeReference + ")";
        }
    }
}

