/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http.executor;

import com.platform.http.executor.Consumer;
import io.appform.core.hystrix.CommandFactory;
import java.util.concurrent.Future;

public interface HttpExecutor<T> {
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";

    public T execute() throws Exception;

    public String getCommand();

    public Consumer<Exception, T> getExceptionConsumer();

    default public T executeTracked(Class clazz) throws Exception {
        try {
            return (T)CommandFactory.create((String)clazz.getSimpleName(), (String)this.getCommand()).executor(this::execute).execute();
        }
        catch (Exception e) {
            Consumer<Exception, Exception> exceptionConsumer = this.getExceptionConsumer();
            if (exceptionConsumer != null) {
                return exceptionConsumer.consume(e);
            }
            throw e;
        }
    }

    default public Future<T> queueTracked(Class clazz) throws Exception {
        return CommandFactory.create((String)clazz.getSimpleName(), (String)this.getCommand()).executor(this::execute).queue();
    }
}

