/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.platform.http.OkHttpUtils;
import com.platform.http.ServiceEndpointProvider;
import com.platform.http.executor.Consumer;
import com.platform.http.executor.ExtractedResponse;
import com.platform.http.executor.HeaderPair;
import com.platform.http.executor.HttpData;
import com.platform.http.executor.HttpExecutor;
import com.platform.http.executor.HttpUtils;
import java.nio.charset.Charset;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpExecutor<T>
implements HttpExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpExecutor.class);
    OkHttpClient client;
    String command;
    ServiceEndpointProvider endpointProvider;
    String url = null;
    List<HeaderPair> headers = null;
    HttpData httpData;
    ObjectMapper mapper;
    Class<T> responseType;
    TypeReference<T> responseTypeReference;
    boolean secure;
    Consumer<Exception, T> exceptionConsumer;
    Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;

    BaseHttpExecutor(OkHttpClient client, String command, ServiceEndpointProvider endpointProvider, String url, List<HeaderPair> headers, HttpData httpData, ObjectMapper mapper, Class<T> responseType, boolean secure, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        this.client = client;
        this.command = command;
        this.endpointProvider = endpointProvider;
        this.url = url;
        this.headers = headers;
        this.httpData = httpData;
        this.mapper = mapper;
        this.responseType = responseType;
        this.secure = secure;
        this.exceptionConsumer = exceptionConsumer;
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
        this.responseTypeReference = responseTypeReference;
    }

    RequestBody getRequestBody() throws JsonProcessingException {
        if (this.httpData.isSerialized()) {
            if (this.httpData.getData() instanceof String) {
                return RequestBody.create((MediaType)MediaType.parse((String)this.httpData.getMediaType()), (String)((String)this.httpData.getData()));
            }
            if (this.httpData.getData() instanceof byte[]) {
                return RequestBody.create((MediaType)MediaType.parse((String)this.httpData.getMediaType()), (byte[])((byte[])this.httpData.getData()));
            }
            throw new IllegalArgumentException("Illegal serialized flag");
        }
        return RequestBody.create((MediaType)MediaType.parse((String)this.httpData.getMediaType()), (byte[])this.mapper.writeValueAsBytes(this.httpData.getData()));
    }

    public abstract Request getRequest(HttpUrl var1) throws JsonProcessingException;

    @Override
    public T execute() throws Exception {
        this.preconditions();
        Request request = null;
        try {
            HttpUrl httpUrl = this.secure ? HttpUtils.getSecureHttpUrl(this.endpointProvider, this.url) : HttpUtils.getHttpUrl(this.endpointProvider, this.url);
            request = this.getRequest(httpUrl);
            log.info("Service {} request: {}", (Object)this.command, (Object)request);
            Response response = this.client.newCall(request).execute();
            byte[] responseBody = OkHttpUtils.body(response);
            if (!response.isSuccessful()) {
                if (this.nonSuccessResponseConsumer != null) {
                    return this.nonSuccessResponseConsumer.consume(this.extract(response, responseBody));
                }
                log.error(String.format("Service %s call failed statusCode:%d request:%s response:%s", this.command, response.code(), request, new String(responseBody)));
                throw new Exception("Service " + this.command + " call failure: " + response.code());
            }
            if (this.responseTypeReference != null) {
                return (T)this.mapper.readValue(responseBody, this.responseTypeReference);
            }
            if (byte[].class.equals(this.responseType)) {
                return (T)responseBody;
            }
            if (String.class.equals(this.responseType)) {
                return (T)new String(responseBody, Charset.defaultCharset());
            }
            return (T)this.mapper.readValue(responseBody, this.responseType);
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                return this.exceptionConsumer.consume(e);
            }
            log.error(String.format("Error executing %s request:%s error:%s", this.command, request, e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public void preconditions() {
        HttpUtils.checkNull(this.client, "client cant be null");
        HttpUtils.checkNull(this.endpointProvider, "endpointProvider cant be null");
        HttpUtils.checkNull(this.url, "url cant be null");
        HttpUtils.checkNull(this.mapper, "object mapper cant be null");
        HttpUtils.checkNull(this.responseType, this.responseTypeReference, "both responseType and responseTypeReference cant be null");
    }

    private ExtractedResponse extract(Response response, byte[] responseBody) {
        return ExtractedResponse.builder().body(responseBody).code(response.code()).headers(response.headers()).message(response.message()).protocol(response.protocol()).handshake(response.handshake()).receivedResponseAtMillis(response.receivedResponseAtMillis()).sentRequestAtMillis(response.sentRequestAtMillis()).build();
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public ServiceEndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    public String getUrl() {
        return this.url;
    }

    public List<HeaderPair> getHeaders() {
        return this.headers;
    }

    public HttpData getHttpData() {
        return this.httpData;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Class<T> getResponseType() {
        return this.responseType;
    }

    public TypeReference<T> getResponseTypeReference() {
        return this.responseTypeReference;
    }

    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public Consumer<Exception, T> getExceptionConsumer() {
        return this.exceptionConsumer;
    }

    public Consumer<ExtractedResponse, T> getNonSuccessResponseConsumer() {
        return this.nonSuccessResponseConsumer;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEndpointProvider(ServiceEndpointProvider endpointProvider) {
        this.endpointProvider = endpointProvider;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(List<HeaderPair> headers) {
        this.headers = headers;
    }

    public void setHttpData(HttpData httpData) {
        this.httpData = httpData;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setResponseType(Class<T> responseType) {
        this.responseType = responseType;
    }

    public void setResponseTypeReference(TypeReference<T> responseTypeReference) {
        this.responseTypeReference = responseTypeReference;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setExceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
        this.exceptionConsumer = exceptionConsumer;
    }

    public void setNonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseHttpExecutor)) {
            return false;
        }
        BaseHttpExecutor other = (BaseHttpExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OkHttpClient this$client = this.getClient();
        OkHttpClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        ServiceEndpointProvider this$endpointProvider = this.getEndpointProvider();
        ServiceEndpointProvider other$endpointProvider = other.getEndpointProvider();
        if (this$endpointProvider == null ? other$endpointProvider != null : !this$endpointProvider.equals(other$endpointProvider)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<HeaderPair> this$headers = this.getHeaders();
        List<HeaderPair> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        HttpData this$httpData = this.getHttpData();
        HttpData other$httpData = other.getHttpData();
        if (this$httpData == null ? other$httpData != null : !((Object)this$httpData).equals(other$httpData)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        Class<T> this$responseType = this.getResponseType();
        Class<T> other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType)) {
            return false;
        }
        TypeReference<T> this$responseTypeReference = this.getResponseTypeReference();
        TypeReference<T> other$responseTypeReference = other.getResponseTypeReference();
        if (this$responseTypeReference == null ? other$responseTypeReference != null : !this$responseTypeReference.equals(other$responseTypeReference)) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        Consumer<Exception, T> this$exceptionConsumer = this.getExceptionConsumer();
        Consumer<Exception, T> other$exceptionConsumer = other.getExceptionConsumer();
        if (this$exceptionConsumer == null ? other$exceptionConsumer != null : !this$exceptionConsumer.equals(other$exceptionConsumer)) {
            return false;
        }
        Consumer<ExtractedResponse, T> this$nonSuccessResponseConsumer = this.getNonSuccessResponseConsumer();
        Consumer<ExtractedResponse, T> other$nonSuccessResponseConsumer = other.getNonSuccessResponseConsumer();
        return !(this$nonSuccessResponseConsumer == null ? other$nonSuccessResponseConsumer != null : !this$nonSuccessResponseConsumer.equals(other$nonSuccessResponseConsumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseHttpExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OkHttpClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        ServiceEndpointProvider $endpointProvider = this.getEndpointProvider();
        result = result * 59 + ($endpointProvider == null ? 43 : $endpointProvider.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<HeaderPair> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        HttpData $httpData = this.getHttpData();
        result = result * 59 + ($httpData == null ? 43 : ((Object)$httpData).hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        Class<T> $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
        TypeReference<T> $responseTypeReference = this.getResponseTypeReference();
        result = result * 59 + ($responseTypeReference == null ? 43 : $responseTypeReference.hashCode());
        result = result * 59 + (this.isSecure() ? 79 : 97);
        Consumer<Exception, T> $exceptionConsumer = this.getExceptionConsumer();
        result = result * 59 + ($exceptionConsumer == null ? 43 : $exceptionConsumer.hashCode());
        Consumer<ExtractedResponse, T> $nonSuccessResponseConsumer = this.getNonSuccessResponseConsumer();
        result = result * 59 + ($nonSuccessResponseConsumer == null ? 43 : $nonSuccessResponseConsumer.hashCode());
        return result;
    }

    public String toString() {
        return "BaseHttpExecutor(client=" + this.getClient() + ", command=" + this.getCommand() + ", endpointProvider=" + this.getEndpointProvider() + ", url=" + this.getUrl() + ", headers=" + this.getHeaders() + ", httpData=" + this.getHttpData() + ", mapper=" + this.getMapper() + ", responseType=" + this.getResponseType() + ", responseTypeReference=" + this.getResponseTypeReference() + ", secure=" + this.isSecure() + ", exceptionConsumer=" + this.getExceptionConsumer() + ", nonSuccessResponseConsumer=" + this.getNonSuccessResponseConsumer() + ")";
    }
}

