/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http;

import com.platform.http.HttpClientConfiguration;
import com.platform.http.RangerEndpointProvider;
import com.platform.http.ServiceEndpointProvider;
import com.platform.http.StaticServiceEndpointProvider;
import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import org.apache.curator.framework.CuratorFramework;

public class ServiceEndpointProviderFactory {
    private final CuratorFramework curatorFramework;

    public ServiceEndpointProviderFactory(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public ServiceEndpointProvider provider(HttpClientConfiguration clientConfiguration, Environment environment) throws Exception {
        if (!clientConfiguration.isUsingZookeeper()) {
            return new StaticServiceEndpointProvider(clientConfiguration);
        }
        final ServiceDiscoveryClient client = ServiceDiscoveryClient.fromCurator().curator(this.curatorFramework).objectMapper(environment.getObjectMapper()).namespace("http").serviceName(clientConfiguration.getServiceName()).environment(clientConfiguration.getEnvironment()).build();
        environment.lifecycle().manage(new Managed(){

            public void start() throws Exception {
                client.start();
            }

            public void stop() throws Exception {
                client.stop();
            }
        });
        return new RangerEndpointProvider(client);
    }
}

