/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http;

import com.codahale.metrics.MetricRegistry;
import com.platform.http.HttpClientConfiguration;
import com.raskasa.metrics.okhttp.InstrumentedOkHttpClients;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public interface OkHttpUtils {
    public static byte[] body(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            byte[] byArray = body.bytes();
            return byArray;
        }
    }

    public static String bodyString(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            String string = body.string();
            return string;
        }
    }

    public static OkHttpClient createOkHttpClient(HttpClientConfiguration httpClientConfiguration) {
        return OkHttpUtils.createOkHttpClient(null, null, httpClientConfiguration);
    }

    public static OkHttpClient createOkHttpClient(String clientName, MetricRegistry registry, HttpClientConfiguration httpClientConfiguration) {
        int connections = httpClientConfiguration.getConnections();
        connections = connections == 0 ? 10 : connections;
        int idleTimeOutSeconds = httpClientConfiguration.getIdleTimeOutSeconds();
        idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;
        int connTimeout = httpClientConfiguration.getConnectTimeoutMs();
        connTimeout = connTimeout == 0 ? 10000 : connTimeout;
        int opTimeout = httpClientConfiguration.getOpTimeoutMs();
        opTimeout = opTimeout == 0 ? 10000 : opTimeout;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().hostnameVerifier((s, sslSession) -> true).connectionPool(new ConnectionPool(connections, (long)idleTimeOutSeconds, TimeUnit.SECONDS)).connectTimeout((long)connTimeout, TimeUnit.MILLISECONDS).readTimeout((long)opTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)opTimeout, TimeUnit.MILLISECONDS).build();
        if (registry != null) {
            okHttpClient = InstrumentedOkHttpClients.create((MetricRegistry)registry, (OkHttpClient)okHttpClient, (String)clientName);
        }
        return okHttpClient;
    }
}

