/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class HttpClientConfiguration {
    private boolean usingZookeeper;
    private String host;
    private int port;
    private String serviceName;
    private String environment;
    private boolean secure;
    @Min(value=10L)
    @Max(value=1024L)
    private int connections = 10;
    @Max(value=86400L)
    private int idleTimeOutSeconds = 30;
    @Max(value=86400000L)
    private int connectTimeoutMs = 10000;
    @Max(value=86400000L)
    private int opTimeoutMs = 10000;
    @Min(value=0L)
    private int asyncWorkers = 10000;
    private String username;
    private String password;

    public static HttpClientConfigurationBuilder builder() {
        return new HttpClientConfigurationBuilder();
    }

    public boolean isUsingZookeeper() {
        return this.usingZookeeper;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getConnections() {
        return this.connections;
    }

    public int getIdleTimeOutSeconds() {
        return this.idleTimeOutSeconds;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getOpTimeoutMs() {
        return this.opTimeoutMs;
    }

    public int getAsyncWorkers() {
        return this.asyncWorkers;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsingZookeeper(boolean usingZookeeper) {
        this.usingZookeeper = usingZookeeper;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setIdleTimeOutSeconds(int idleTimeOutSeconds) {
        this.idleTimeOutSeconds = idleTimeOutSeconds;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setOpTimeoutMs(int opTimeoutMs) {
        this.opTimeoutMs = opTimeoutMs;
    }

    public void setAsyncWorkers(int asyncWorkers) {
        this.asyncWorkers = asyncWorkers;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfiguration)) {
            return false;
        }
        HttpClientConfiguration other = (HttpClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUsingZookeeper() != other.isUsingZookeeper()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        if (this.getConnections() != other.getConnections()) {
            return false;
        }
        if (this.getIdleTimeOutSeconds() != other.getIdleTimeOutSeconds()) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        if (this.getOpTimeoutMs() != other.getOpTimeoutMs()) {
            return false;
        }
        if (this.getAsyncWorkers() != other.getAsyncWorkers()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUsingZookeeper() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        result = result * 59 + (this.isSecure() ? 79 : 97);
        result = result * 59 + this.getConnections();
        result = result * 59 + this.getIdleTimeOutSeconds();
        result = result * 59 + this.getConnectTimeoutMs();
        result = result * 59 + this.getOpTimeoutMs();
        result = result * 59 + this.getAsyncWorkers();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientConfiguration(usingZookeeper=" + this.isUsingZookeeper() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", serviceName=" + this.getServiceName() + ", environment=" + this.getEnvironment() + ", secure=" + this.isSecure() + ", connections=" + this.getConnections() + ", idleTimeOutSeconds=" + this.getIdleTimeOutSeconds() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", opTimeoutMs=" + this.getOpTimeoutMs() + ", asyncWorkers=" + this.getAsyncWorkers() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public HttpClientConfiguration(boolean usingZookeeper, String host, int port, String serviceName, String environment, boolean secure, int connections, int idleTimeOutSeconds, int connectTimeoutMs, int opTimeoutMs, int asyncWorkers, String username, String password) {
        this.usingZookeeper = usingZookeeper;
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        this.environment = environment;
        this.secure = secure;
        this.connections = connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs;
        this.asyncWorkers = asyncWorkers;
        this.username = username;
        this.password = password;
    }

    public HttpClientConfiguration() {
    }

    public static class HttpClientConfigurationBuilder {
        private boolean usingZookeeper;
        private String host;
        private int port;
        private String serviceName;
        private String environment;
        private boolean secure;
        private int connections;
        private int idleTimeOutSeconds;
        private int connectTimeoutMs;
        private int opTimeoutMs;
        private int asyncWorkers;
        private String username;
        private String password;

        HttpClientConfigurationBuilder() {
        }

        public HttpClientConfigurationBuilder usingZookeeper(boolean usingZookeeper) {
            this.usingZookeeper = usingZookeeper;
            return this;
        }

        public HttpClientConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        public HttpClientConfigurationBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HttpClientConfigurationBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public HttpClientConfigurationBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public HttpClientConfigurationBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public HttpClientConfigurationBuilder connections(int connections) {
            this.connections = connections;
            return this;
        }

        public HttpClientConfigurationBuilder idleTimeOutSeconds(int idleTimeOutSeconds) {
            this.idleTimeOutSeconds = idleTimeOutSeconds;
            return this;
        }

        public HttpClientConfigurationBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public HttpClientConfigurationBuilder opTimeoutMs(int opTimeoutMs) {
            this.opTimeoutMs = opTimeoutMs;
            return this;
        }

        public HttpClientConfigurationBuilder asyncWorkers(int asyncWorkers) {
            this.asyncWorkers = asyncWorkers;
            return this;
        }

        public HttpClientConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public HttpClientConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.usingZookeeper, this.host, this.port, this.serviceName, this.environment, this.secure, this.connections, this.idleTimeOutSeconds, this.connectTimeoutMs, this.opTimeoutMs, this.asyncWorkers, this.username, this.password);
        }

        public String toString() {
            return "HttpClientConfiguration.HttpClientConfigurationBuilder(usingZookeeper=" + this.usingZookeeper + ", host=" + this.host + ", port=" + this.port + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", secure=" + this.secure + ", connections=" + this.connections + ", idleTimeOutSeconds=" + this.idleTimeOutSeconds + ", connectTimeoutMs=" + this.connectTimeoutMs + ", opTimeoutMs=" + this.opTimeoutMs + ", asyncWorkers=" + this.asyncWorkers + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

