/*
 * Decompiled with CFR 0.152.
 */
package com.platform.http;

import java.net.URI;
import okhttp3.HttpUrl;

public class Endpoint {
    private String host;
    private int port;

    public HttpUrl url(String path) {
        return HttpUrl.get((URI)URI.create(String.format("http://%s:%d%s", this.host, this.port, path)));
    }

    public HttpUrl secureUrl(String path) {
        return HttpUrl.get((URI)URI.create(String.format("https://%s:%d%s", this.host, this.port, path)));
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Endpoint(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Endpoint() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        return result;
    }

    public String toString() {
        return "Endpoint(host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public static class EndpointBuilder {
        private String host;
        private int port;

        EndpointBuilder() {
        }

        public EndpointBuilder host(String host) {
            this.host = host;
            return this;
        }

        public EndpointBuilder port(int port) {
            this.port = port;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.host, this.port);
        }

        public String toString() {
            return "Endpoint.EndpointBuilder(host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

