package com.platform.http.executor;

import com.platform.http.Endpoint;
import com.platform.http.ServiceEndpointProvider;
import okhttp3.HttpUrl;

import java.util.Optional;

/**
 * @author tushar.naik
 * @version 1.0  11/11/17 - 12:22 AM
 */
public interface HttpUtils {

    /**
     * @param endpointProvider host port details
     * @param url              uri path
     * @return secure {@link HttpUrl}
     */
    static HttpUrl getSecureHttpUrl(ServiceEndpointProvider endpointProvider, String url) {
        Optional<Endpoint> endpointOptional = endpointProvider.endpoint();
        if (!endpointOptional.isPresent()) {
            throw new RuntimeException("Client endpoints have not been configured");
        }
        return endpointOptional.get().secureUrl(url);
    }

    /**
     * @param endpointProvider host port details
     * @param url              uri path
     * @return secure {@link HttpUrl}
     */
    static HttpUrl getHttpUrl(ServiceEndpointProvider endpointProvider, String url) {
        Optional<Endpoint> endpointOptional = endpointProvider.endpoint();
        if (!endpointOptional.isPresent()) {
            throw new RuntimeException("Client endpoints have not been configured");
        }
        return endpointOptional.get().url(url);
    }

    static <T> void checkNull(T t, String message) {
        if (t == null) {
            throw new RuntimeException(message);
        }
    }

    static <T1, T2> void checkNull(T1 t, T2 t2, String message) {
        if (t == null && t2 == null) {
            throw new RuntimeException(message);
        }
    }
}
