package com.platform.http.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.platform.http.ServiceEndpointProvider;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;

import java.util.List;

import static com.platform.http.executor.HttpUtils.checkNull;


/**
 * This is a generic flow execution
 * Basically a wrapper, that makes a patch call on a client, using all the resources provided
 */
@Data
@Slf4j
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class HttpPatchExecutor<T> extends BaseHttpExecutor<T> {

    public void preconditions() {
        super.preconditions();
        checkNull(httpData, "patchData cant be null");
    }

    @Builder
    public HttpPatchExecutor(OkHttpClient client, String command,
                             ServiceEndpointProvider endpointProvider, String url,
                             @Singular("header") List<HeaderPair> headers,
                             HttpData httpData, ObjectMapper mapper,
                             Class<T> responseType, boolean secure,
                             Consumer<Exception, T> exceptionConsumer,
                             Consumer<ExtractedResponse, T> nonSuccessResponseConsumer,
                             TypeReference<T> responseTypeReference) {
        super(client, command, endpointProvider, url, headers, httpData, mapper, responseType, secure,
                exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    public Request getRequest(HttpUrl httpUrl) throws JsonProcessingException {
        Request.Builder requestBuilder = new Request.Builder()
                .url(httpUrl)
                .patch(getRequestBody());
        if (headers != null) {
            headers.forEach(h -> requestBuilder.header(h.getName(), h.getValue()));
        }
        return requestBuilder.build();
    }
}
