package com.platform.http.executor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.platform.http.ServiceEndpointProvider;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

import java.util.List;


/**
 * @author tushar.naik
 * @version 1.0  11/11/17 - 12:09 AM
 */
@Slf4j
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class HttpGetExecutor<T> extends BaseHttpExecutor<T> {

    @Builder
    public HttpGetExecutor(OkHttpClient client, String command,
                           ServiceEndpointProvider endpointProvider, String url,
                           @Singular("header") List<HeaderPair> headers, ObjectMapper mapper,
                           Class<T> responseType, boolean secure,
                           Consumer<Exception, T> exceptionConsumer,
                           Consumer<ExtractedResponse, T> nonSuccessResponseConsumer,
                           TypeReference<T> responseTypeReference) {
        super(client, command, endpointProvider, url, headers, null, mapper, responseType, secure,
              exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    public Request getRequest(HttpUrl httpUrl) {
        Request.Builder requestBuilder = new Request.Builder()
                .url(httpUrl)
                .get();
        if (headers != null) {
            headers.forEach(h -> requestBuilder.header(h.getName(), h.getValue()));
        }
        return requestBuilder.build();
    }
}
